<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:java="http://xml.apache.org/xslt/java"
	xmlns:util="xalan://org.greenstone.gsdl3.util.XSLTUtil"
	xmlns:gslib="http://www.greenstone.org/skinning"
	xmlns:gsf="http://www.greenstone.org/greenstone3/schema/ConfigFormat"	
	extension-element-prefixes="java util"
	exclude-result-prefixes="java util">

  <!-- This page, structurally speaking, is a hybrid of home.xsl and about.xsl -->
  <!-- If no collection argument is explicitly given, then produces a general
       embedded GLI, however if a collection is specified, then it produced
       a page with a navigation area akin to an about this page, only with
       GLI embedd in it, rather than about this collection txt   -->
  
	<!-- use the 'main' layout -->
	<xsl:import href="layouts/main.xsl"/>

	<!-- what is this used for??? Can it be deleted? -->
	<xsl:variable name="groupPath"><xsl:value-of select="/page/pageRequest/paramList/param[@name='group']/@value"/></xsl:variable>

	<!-- set page title -->

	<xsl:template name="pageTitle">
	  WebSwing GLI
	</xsl:template>


	<!-- set page breadcrumbs -->
	<xsl:template name="breadcrumbs">
	  <xsl:choose>
	    <xsl:when test="/page/pageRequest/paramList/param[@name='c']/@value != ''">
              <gslib:siteLink/>
              <gslib:rightArrow/>
	      <xsl:if test="$groupPath != ''">
		<gslib:groupLinks/>
		<gslib:rightArrow/>
	      </xsl:if>
	      <a href="{$library_name}/collection/{$collName}/page/about">
		<gslib:collectionName/>
	      </a>
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:choose>
		<xsl:when test="$groupPath != ''">
		  <a>
		    <xsl:attribute name="href"><gslib:groupHref path="{$groupPath}"/></xsl:attribute>
		    <xsl:attribute name="title"><gslib:groupName path="{$groupPath}"/></xsl:attribute>
		    <gslib:groupName path="{$groupPath}"/>
		  </a>
		</xsl:when>
		<xsl:otherwise>
		  <gslib:siteLink/>
		</xsl:otherwise>
	      </xsl:choose>
	      
	    </xsl:otherwise>
	  </xsl:choose>
	</xsl:template>


	<!-- the page content -->
	<xsl:template match="/page">
  
		<xsl:choose>
			<xsl:when test="$this-element/displayItemList/displayItem[@name='icon']">
			  <img border="0">
				<xsl:attribute name="src"><xsl:value-of select="$this-element/metadataList/metadata[@name='httpPath']"/>/images/<xsl:value-of select="$this-element/displayItemList/displayItem[@name='icon']"/></xsl:attribute>
				<xsl:attribute name="alt">
				  <xsl:value-of select="$this-element/displayItemList/displayItem[@name='name']"/>
				</xsl:attribute>
				<xsl:attribute name="title">
				  <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'webswing_glipage')"/>
				</xsl:attribute>
			  </img>		
			</xsl:when>      
		</xsl:choose>

		<div id="gli-displaying-info" style="display:none">Webswing GLI</div>
		<!--Display the description text of the current collection,
		and if some services are available then create a list
		of links for each service within a <ul id="servicelist"> element.-->
		<xsl:call-template name="webswing-embed-gli"/>
	</xsl:template>
	
	<xsl:template name="webswing-embed-gli">
	  <link rel="stylesheet" href="/{$webswing_context}/css/style.css" />

	  <div id="webswing-gli" class="webswing-element" data-webswing-instance="webswingInstance0" style="height: 600px;">
	    <div id="loading" class="ws-modal-container">
              <div class="ws-login">
		<div  class="ws-login-content">
                  <div class="ws-spinner">
		    <div class="ws-spinner-dot-1"><xsl:comment>filler</xsl:comment></div>
		    <div class="ws-spinner-dot-2"><xsl:comment>filler</xsl:comment></div>
		  </div>
		</div>
              </div>
	    </div>
	  </div>

	  <gsf:script>

    var webswingInstance0 = {
        options: {
            autoStart: true,
	  
            connectionUrl:'/' + gs.xsltParams.webswing_context + '/gli',

	    customization: function(injector) {
	    injector.services.base.handleActionEvent = function(actionName, data, binaryData) {
       	        console.log("WebSwing actionEvent callback handler: called with actionName = " + actionName);
	        if (actionName == "previewURL") {
	          var url = data;
	          window.open(url, '_blank');
		}
	        else if (actionName == "downloadURL") {
		  // currently the same as 'previewURL' but separate name gives this some future proofing
	          var url = data;
	          window.open(url, '_blank');
		}
	        else if (actionName == "setCursor") {
		    var cursor_type = data;
		    $('#webswing-gli').css("cursor",cursor_type);		    
		}
		else if (actionName == "javaToWebswingJSConsoleLog") {
		    console.log("Got message from java:\n" + data);
		}
	      }
            }

	    
       }
       };
       if (gs.cgiParams.c) {
       webswingInstance0.options.args = "-load " + gs.cgiParams.c + "/gli.col";
       }
       if(gs.userInformation.username &amp;&amp; gs.userInformation.uid) { // true if defined and not empty string etc
       // doing "args +=" adds "undefined" parameter iff it's first argument attached to webswing customArgs
       // This then has the effect of switching of the previous argument, -webswing
         if (gs.cgiParams.c) {
           webswingInstance0.options.args += " -username " + gs.userInformation.username;
	 } else {
	   webswingInstance0.options.args = "-username " + gs.userInformation.username;
	 }
         webswingInstance0.options.args += " -groups " + gs.userInformation.groups.replace(/\s/g, '');
         webswingInstance0.options.args += " -uid " + gs.userInformation.uid;
       }
    function getParam(name) {
        name = name.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
        var results = new RegExp("[\\?&amp;]" + name + "=([^&amp;#]*)").exec(location.href);
        return results == null ? null : decodeURIComponent(results[1]);
    }
  </gsf:script>

	  
  <script data-webswing-global-var="webswing">
    <xsl:text disable-output-escaping="yes">
    (function (window, document) {
        var loader = function () {
            var baseUrl = '/' + gs.xsltParams.webswing_context+ '/gli';
            baseUrl = baseUrl.indexOf("/", baseUrl.length - 1) !== -1 ? baseUrl : (baseUrl + "/");
            var xmlhttp = new XMLHttpRequest();
            xmlhttp.onreadystatechange = function () {
                if (xmlhttp.readyState == XMLHttpRequest.DONE) {
                    var version = xmlhttp.status == 200 ? xmlhttp.responseText : "undefined";
                    var script = document.createElement("script"),
                        tag = document.getElementsByTagName("script")[0];
                    script.src = baseUrl + "javascript/webswing-embed.js?version=" + version;
                    tag.parentNode.insertBefore(script, tag);
		    
		    if (xmlhttp.status != 200) { // possibly no webswing-server
		      document.getElementById("webswing-gli").style.setProperty("display", "none", "important");

		      document.getElementById("gli-displaying-info").style.setProperty("display", "block", "important");
		      document.getElementById("gli-displaying-info").textContent += " cannot be displayed as the webswing extension it requires has possibly been deactivated.";		      
		    }
                }
            };
            xmlhttp.open("GET", baseUrl + "rest/version", true);
            xmlhttp.send();
        };
        window.addEventListener ? window.addEventListener("load", loader, false) : window.attachEvent("onload", loader);
	})(window, document);
    </xsl:text>
  </script>



	</xsl:template>

</xsl:stylesheet>  

