<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:java="http://xml.apache.org/xslt/java"
	xmlns:util="xalan://org.greenstone.gsdl3.util.XSLTUtil"
	xmlns:gslib="http://www.greenstone.org/skinning"
	xmlns:gsf="http://www.greenstone.org/greenstone3/schema/ConfigFormat" 
	extension-element-prefixes="java util"
	exclude-result-prefixes="java util gslib gsf">

	<!-- use the 'main' layout -->
	<xsl:include href="layouts/main.xsl"/>
	
	<!-- set page title -->
	<xsl:template name="pageTitle"><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'depositor.title')"/></xsl:template>

	<!-- set page breadcrumbs -->
	<xsl:template name="breadcrumbs">	  
	  <gslib:siteLink/><gslib:rightArrow/><gslib:depositorTitleAndLink/><gslib:rightArrow/>
	  <xsl:if test="/page/pageResponse/collection">
	    <gslib:collectionNameLinked/><gslib:rightArrow/>
	  </xsl:if>
	</xsl:template>
	
	<xsl:template match="/page">
	  <xsl:choose>
	    <xsl:when test="/page/pageResponse/error">
              <div id="gs_error" class="ui-state-error ui-corner-all">
                <span class="ui-icon ui-icon-alert" style="float: left;"><xsl:text> </xsl:text></span><xsl:value-of select="/page/pageResponse/error"/>
              </div>
              <br/>
            </xsl:when>
	    <xsl:otherwise>
	      <xsl:choose>
		<xsl:when test="/page/pageResponse/depositorPage/collectionList/collection">
		<div style="display:table; margin: 0 auto">
			<xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'depositor.select_collection')"/><gsf:space/>
			<select id="colSelect">
				<option><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'depositor.select_collection_option')"/></option>
				<xsl:for-each select="/page/pageResponse/depositorPage/collectionList/collection">
					<option>
						<xsl:value-of select="@name"/>
					</option>
				</xsl:for-each>
			</select>

			<script type="text/javascript">
				<xsl:text disable-output-escaping="yes">
				  var availableDepositorCols = [
				</xsl:text>
				<xsl:for-each select="/page/pageResponse/depositorPage/collectionList/collection">
				  <xsl:text disable-output-escaping="yes">"</xsl:text><xsl:value-of select="@name"/><xsl:text disable-output-escaping="yes">"</xsl:text>,
				</xsl:for-each>
				<xsl:text disable-output-escaping="yes">
				  null ] <!-- to simplify array initialization -->
				</xsl:text>
			</script>

			<script type="text/javascript">
				<xsl:text disable-output-escaping="yes">
				  var col = gs.cgiParams["c"];
				  if (col &amp;&amp; availableDepositorCols.includes(col)) { 
				      document.location.href = gs.xsltParams.library_name + "?a=de&amp;sa=getwizard&amp;c=" + col;
				  }    
				</xsl:text>
			</script>

			<script type="text/javascript">
				<xsl:text disable-output-escaping="yes">
					$("#colSelect").change(function()
					{
						var selected = $("#colSelect").find(":selected");
						if (selected.text() != "-- Select a collection --")
						{
							document.location.href = gs.xsltParams.library_name + "?a=de&amp;sa=getwizard&amp;c=" + selected.text();
						}
					});
				</xsl:text>
			</script>
		</div>
		</xsl:when>
		<xsl:otherwise>
		  <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'depositor.no_valid_collection')"/>
		</xsl:otherwise>
	      </xsl:choose>
	    </xsl:otherwise>
	  </xsl:choose>
	</xsl:template>
</xsl:stylesheet>  

