#!/bin/bash

package=zlib
version=-1.2.11

progname=$0

source ../cascade-make/lib/cascade-lib.bash GEXTGNOME ../.. $*

prefix=$GEXTGNOME_INSTALLED

if [ "x$CROSSCONFIGURE_ARGS" != "x" ] ; then
  if [ "x$crossOS" = "xwindows" ] ; then
      export LDSHAREDLIBC=-lcrtdll
  fi
    # zlib configure does not support '--host'
    export CROSSCONFIGURE_ARGS=
fi


opt_run_untar $force_untar $auto_untar $package $version

#opt_run_configure $force_config $auto_config $package $version $prefix

if [ $auto_config = "1" ] ; then
  if [ ! -f $package$version/configure.log ] ; then
    force_config=1
  fi

fi

if [ $force_config = "1" ] ; then
    echo "[pushd $package$version]"
    ( cd $package$version ; \
      echo $CROSSCONFIGURE_VARS ./configure --static --prefix="$prefix" $CROSSCONFIGURE_ARGS $@ ; \
      eval $CROSSCONFIGURE_VARS ./configure --static --prefix="$prefix" $CROSSCONFIGURE_ARGS $@ )
    if [ $? != 0 ] ; then
        echo "      Error encountered running *configure* stage of $progname"
        exit 1
    fi
    echo "[popd]"
  else
    if [ $auto_config = "1" ] ; then
      echo "Found top-level for ${progname%.*} => no need to run ./configure"
    fi
fi



opt_run_make $compile $package $version
opt_run_make $install $package $version "install"
opt_run_make $clean $package $version "clean"
opt_run_make $distclean $package $version "distclean"

opt_run_tarclean $tarclean $package $version
