#!/bin/bash

# libxml2.2.9.0 was modified for Greenstone to allow compilation to succeed on a Mac, so it has acquired a 'gs-' prefix
package=gs-libxml2
version=-2.9.0

progname=$0

source ../cascade-make/lib/cascade-lib.bash GEXTGNOME ../.. $*

prefix=$GEXTGNOME_INSTALLED

export CFLAGS="$CFLAGS -DLIBXML_STATIC"

opt_run_untar $force_untar $auto_untar $package $version
opt_run_configure $force_config $auto_config $package $version $prefix \
  --without-python --disable-shared --enable-static

opt_run_make $compile $package $version
opt_run_make $install $package $version "install"
opt_run_make $clean $package $version "clean"
opt_run_make $distclean $package $version "distclean"

opt_run_tarclean $tarclean $package $version