#!/bin/bash

# glib2.28.1 was modified for Greenstone to allow compilation to succed on a Mac, so it has acquired a 'gs-' prefix
# More recently compiling on Mojave (MacOS) newer compilation errors were encountered, 
# prompting a signficant bump up in version number
# Back to using gs- prefix as this newer glib needed customisations for linux 64 bit LSB env,
# see packages/README.txt for details

package=gs-glib
#package=glib
#version=-2.24.2
#version=-2.28.1
##version=-2.34.3
version=-2.54.3

progname=$0

source ../cascade-make/lib/cascade-lib.bash GEXTGNOME ../.. $*

prefix=$GEXTGNOME_INSTALLED

export CFLAGS="$CFLAGS -I$GEXTGNOME_INSTALLED/include"
export CPPFLAGS="$CPPFLAGS -I$GEXTGNOME_INSTALLED/include"
export CXXFLAGS="$CXXFLAGS -I$GEXTGNOME_INSTALLED/include"
export LDFLAGS="$LDFLAGS -L$GEXTGNOME_INSTALLED/lib"

export LIBFFI_CFLAGS="-I$GEXTGNOME_INSTALLED/lib/libffi-3.0.11/include"
export LIBFFI_LIBS="-L$GEXTGNOME_INSTALLED/lib -lffi"

export PCRE_CFLAGS="-I$GEXTGNOME_INSTALLED/include"
export PCRE_LIBS="-L$GEXTGNOME_INSTALLED/lib -lpcre"

if [ "x$crossOS" = "xandroid" ] ; then
  # Based on details found at:
  #   http://axcoto.com/blog/article/836
  extra_config_args="glib_cv_stack_grows=${glib_cv_stack_grows=no} glib_cv_uscore=${glib_cv_uscore=no} ac_cv_func_posix_getpwuid_r=${ac_cv_func_posix_getpwuid_r=no} ac_cv_func_posix_getgrgid_r=${ac_cv_func_posix_getgrgid_r=no}"

  # Not clear how many of the following are needed.
  # List came from:
  #  https://mail.gnome.org/archives/gtk-devel-list/2011-March/msg00096.html
  #
  # Could be that some of these are helpful in general (i.e. move out to
  #   main section of this script) in making a more minimal glib

  extra_config_args="--without-included-regex --disable-java --disable-openmp --without-libiconv-prefix --without-libintl-prefix --without-libglib-2.0-prefix --without-libcroco-0.6-prefix --with-included-libxml --without-libncurses-prefix --without-libtermcap-prefix --without-libcurses-prefix --without-libexpat-prefix --without-emacs $extra_config_args"


else
  extra_config_args=
fi

# Disabling libmount, as it breaks compilation:
# - http://unix.stackexchange.com/questions/327019/ddg#398242
#   "Unless you actually need libmount for something it's much easier
#   to simply disable it by passing --enable-libmount=no to configure"
# - http://linuxfromscratch.org/lfs/view/systemd/chapter08/util-linux.html
#   "Purpose of libmount: Contains routines for block device mounting and unmounting"
opt_run_untar $force_untar $auto_untar $package $version
opt_run_configure $force_config $auto_config $package $version $prefix \
		  --disable-shared --enable-static --disable-dtrace --disable-systemtap \
		  --enable-libmount=no $extra_config_args

# In the above ...
# Linking error can occur when compiling due to mix of wanting static libraries built 
# and 'dtrace' and 'systemtap' being present on the underlying linux system
# Details relating to the linking error disucssed at:
#    https://gitlab.gnome.org/GNOME/glib/issues/653
# Since we don't want to move to a newer version of the the gslib library (at this stage)
# the workaround is to add in:
#    --disable-dtrace and --disable-systemtap in 

opt_run_make $compile $package $version
opt_run_make $install $package $version "install"
opt_run_make $clean $package $version "clean"
opt_run_make $distclean $package $version "distclean"

opt_run_tarclean $tarclean $package $version
