#!/bin/bash

package=gettext
#version=-0.18.1.1
version=-0.18.2

progname=$0

source ../cascade-make/lib/cascade-lib.bash GEXTGNOME ../.. $*

prefix=$GEXTGNOME_INSTALLED

if [ "x$CROSSCONFIGURE_ARGS" != "x" ] ; then

  if [ $crossOS = "android" ] ; then
    export CROSSCONFIGURE_VARS="$CROSSCONFIGURE_VARS \
          gl_cv_header_working_stdint_h=yes"
  fi

  if [ $crossOS = "windows" ] ; then
    export CROSSCONFIGURE_VARS="$CROSSCONFIGURE_VARS \
          gl_cv_func_memchr_works=yes
          ac_cv_func_strnlen_working=yes"
  fi
fi

opt_run_untar $force_untar $auto_untar $package $version
opt_run_configure $force_config $auto_config $package $version $prefix --without-emacs --without-git --disable-shared --enable-static

opt_run_make $compile $package $version
opt_run_make $install $package $version "install"
opt_run_make $clean $package $version "clean"
opt_run_make $distclean $package $version "distclean"

opt_run_tarclean $tarclean $package $version