/**********************************************************************
 *
 * jdbmnaiveclass.h -- 
 * Copyright (C) 1999-2010  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifndef JDBMNAIVECLASS_H
#define JDBMNAIVECLASS_H

// This implementation is simple but potentially inefficient (hence 'naive')
// For each operation is runs a separate "java -cp ... " command
// A more efficient implementation would open a connection to
// JdbmAPI and then use a bi-directional pipe for issuing commands and
// (in the case of Get) reading back the answer.
//
// While there is off-the-shelf code for a bi-directional pipe for Unix
// (see gsdl-music) this has not yet been implemented for Windows (would need
// to make use of Windows native calls to CreatePipe and CreateProcess)

#include "gsdlconf.h"
#include "dbclass.h"

class jdbmnaiveclass : public dbclass
{
public:
  jdbmnaiveclass(const text_t& gsdlhome);
  ~jdbmnaiveclass();

  // returns true if opened
  bool opendatabase (const text_t &filename, int mode, int num_retrys, bool need_filelock);

  void closedatabase ();

  void deletekey (const text_t &key);

  // returns file extension string
  text_t getfileextension ();

  // returns true on success
  bool getkeydata (const text_t& key, text_t &data);

  // returns array of keys
  text_tarray getkeys ();

  // returns true on success
  bool setkeydata (const text_t &key, const text_t &data);

protected:
  text_t openfile_;
  text_t classpath_;
  char*  classpath_cstr_;
  text_t gsdlhome_;
};


#endif
