/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * Author: John Thompson, Greenstone Digital Library, University of Waikato
 *
 * Copyright (C) 1999 New Zealand Digital Library Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.util;


/** Were you to guess that this is a class object choc-a-block full of static stringy goodness, you'd be right. They come in several flavours: Those ending _STR are strings you might find as values in XML, _ELEMENT are element names, _ATTRIBUTE are attribute names, _CHAR are particular characters while _CHARACTER are also characters but expressed as strings (for regex purposes ie startsWith, endsWith, indexOf and replaceAll); _PATTERN are strings which require extra escaping to put them through regex. Finally anything else is just a static string used within GLI. */
public class StaticStrings {
    static final public char CLOSEBRACKET_CHAR = ']';
    static final public char DOUBLEQUOTE_CHAR = '\"';
    static final public char BACKSLASH_CHAR = '\\';
    static final public char FORWARDSLASH_CHAR = '/';
    static final public char NEW_LINE_CHAR = '\n';
    static final public char NS_SEP = '.';
    static final public char OPENBRACKET_CHAR = '[';
    static final public char SINGLEQUOTE_CHAR = '\'';
    static final public char SPACE_CHAR = ' ';
    static final public char STAR_CHAR = '*';
    static final public String ACCENTFOLD_OPTION_STR = "accentfold";
    static final public String ALLFIELDS_STR = "allfields";
    static final public String ARCPLUG_STR = "ArchivesInfPlugin";
    static final public String ASSIGNED_ATTRIBUTE = "assigned";
    static final public String ASSOCIATIONS_ELEMENT = "Associations";
    static final public String ATTRIBUTE_ELEMENT = "Attribute";
    static final public String BROWSE_STR = "browse";
    static final public String BUILDTYPE_ELEMENT = "BuildType";
    static final public String BUILDTYPE_STR = "buildtype";
    static final public String CASEFOLD_OPTION_STR = "casefold";
    static final public String CCS_STR = "ccs";
    static final public String CLASSIFIER_STR = "classifier";
    static final public String CLASSIFY_ELEMENT = "Classify";
    static final public String CLASSIFY_STR = "classify";
    static final public String CLOSE_PARENTHESIS_CHARACTER = ")";
    static final public String CODE_ATTRIBUTE = "code";
    static final public String COLNAME_PATTERN = "<col_name>";
    static final public String COLLECT_CFG = "collect.cfg";
    static final public String COLLECTION_CFG_XML = "collectionConfig.xml";
    static final public String COLLECTDIR_ARGUMENT = "-collectdir";
    static final public String COLLECTION_ELEMENT = "Collection";
    static final public String COLLECTION_STR = "Collection: ";
    static final public String COLLECTIONMETADATA_COLLECTIONNAME_STR = "collectionname";
    static final public String COLLECTIONMETADATA_COLLECTIONEXTRA_STR = "collectionextra";
    static final public String COLLECTIONMETADATA_CREATOR_ELEMENT = "Creator";
    static final public String COLLECTIONMETADATA_CREATOR_STR = "creator";
    static final public String COLLECTIONMETADATA_ELEMENT = "CollectionMetadata";
    static final public String SEARCHMETADATA_ELEMENT = "SearchMetadata";
    static final public String COLLECTIONMETADATA_ICONCOLLECTION_STR = "iconcollection";
    static final public String COLLECTIONMETADATA_ICONCOLLECTIONSMALL_STR = "iconcollectionsmall";
    static final public String COLLECTIONMETADATA_MAINTAINER_ELEMENT = "Maintainer";
    static final public String COLLECTIONMETADATA_MAINTAINER_STR = "maintainer";
    static final public String COLLECTIONMETADATA_PUBLIC_ELEMENT = "Public";
    static final public String COLLECTIONMETADATA_PUBLIC_STR = "public";
    static final public String COLLECTIONMETADATA_COLLECTGROUP_STR = "collectgroup";
    static final public String COLLECTIONMETADATA_STR = "collectionmeta";
    static final public String COLON_CHARACTER = ":";
    static final public String COMMA_CHARACTER = ",";
    static final public String COMMENTED_INDEXES_STR = "#indexes";
    static final public String COMMENTED_INDEX_DEFAULT_STR = "#defaultindex";
    static final public String COMMENTED_LEVELS_STR = "#levels";
    static final public String COMMENTED_LEVEL_DEFAULT_STR = "#defaultlevel";
    static final public String COMMENTED_INDEXOPTIONS_STR = "#indexoptions";
    static final public String CONTENT_ATTRIBUTE = "content";
    static final public String CONTENT_ELEMENT = "content";
    static final public String DATABASETYPE_ELEMENT = "infodbtype";
    static final public String DATABASETYPE_STR = "infodbtype";
    static final public String DATELIST_CLASSIFIER = "DateList";
    static final public String DEBUG_ARGUMENT = "-debug";
    static final public String DESCRIPTION_ELEMENT = "Description";
    static final public String DESCRIPTION_STR = "description";
    static final public String DICTIONARY_ATTRIBUTE = "dictionary";
    static final public String DIRECTORY_MAPPINGS_ELEMENT = "DirectoryMappings";
    static final public String DISPLAYITEMLIST_STR = "displayItemList";
    static final public String DISPLAY_STR = "display";
    static final public String DISPLAYITEM_STR = "displayItem";
    static final public String DISPLAYITEM_ELEMENT = "DisplayItem"; // Note: 1st letter is titlecase
    static final public String DOCUMENT_STR = "document";
    static final public String DOT_CHARACTER = ".";
    static final public String EMBEDMETAPLUG_STR = "EmbeddedMetadataPlugin";
    static final public String EMPTY_STR = "";
    static final public String ENGLISH_LANGUAGE_STR = "en";
    static final public String ENTRY_ELEMENT = "Entry";
    static final public String ENUM_STR = "enum";
    static final public String ENUM_STRING_STR = "enumstring";
    static final public String EQUALS_CHARACTER = "=";
    static final public String EXCLAMATION_CHARACTER = "!";
    static final public String EXCLUDE_STR = "exclude";
    static final public String EXTENSION_ATTRIBUTE = "extension";
    static final public String EXTRACTED_NAMESPACE = "ex.";
    static final public String FACET_ELEMENT = "Facet";
    static final public String FACETS_ELEMENT = "Facets";
    static final public String FACET_STR = "Facet";
    static final public String FACET_LOW_STR = "facet";
    static final public String FALSE_STR = "false";
    static final public String FEEDBACK_ARGUMENT = "-feedback";
    static final public String FILE_ATTRIBUTE = "file";
    static final public String FILENAME_STR = "Filename";
    static final public String FILTER_ATTRIBUTE = "filter";
    static final public String FLAG_STR = "flag";
    static final public String FORMAT_ELEMENT = "Format";
    static final public String FORMAT_STR = "format";
    static final public String FORMAT_START_TAG = "<format>";
    static final public String FORMAT_END_TAG = "</format>";
    static final public String FURTHER_DIALOG_INDICATOR = "...";
    static final public String FEDORA_MODE= "-fedora";
    static final public String FEDORA_HOME = "-fedora_home";
    static final public String FEDORA_VERSION = "-fedora_version";
    static final public String FEDORA_HOSTNAME = "-fedora_hostname";
    static final public String FEDORA_PORT     = "-fedora_port";
    static final public String FEDORA_USERNAME = "-fedora_username";
    static final public String FEDORA_PASSWORD = "-fedora_password";
    static final public String FEDORA_PROTOCOL = "-fedora_protocol";
    static final public String GLI_ATTRIBUTE = "gli";
    static final public String GLISERVER_URL_ARGUMENT = "-gliserver_url";
  static final public String GLOBAL_STR = "global";
    static final public String GREATER_THAN_CHARACTER = ">";
    static final public String GSDL_ARGUMENT = "-gsdl";
    static final public String GSDL3_WEB_ARGUMENT = "-gsdl3web";
    static final public String GSDL3_WRITABLEWEB_ARGUMENT = "-gsdl3writableweb";
    static final public String GSDL3_SRC_ARGUMENT = "-gsdl3src";
    static final public String GSDLOS_ARGUMENT = "-gsdlos";
    static final public String HFILE_ARGUMENT = "-hfile";
    static final public String HIERARCHY_CLASSIFIER = "Hierarchy";
    static final public String HIERARCHY_STR = "hierarchy";
    static final public String HELP_ARGUMENT = "-help";
    static final public String HTM_FILE_EXTENSION = ".htm";
    static final public String ICON_STR = "icon";
    static final public String ID_STR = "id";
    static final public String IMAGES_PATH_RELATIVE_TO_GSDL_PREFIX = "_httpprefix_/collect/<col_name>/images/";
    static final public String INCLUDE_STR = "include";
    static final public String INDEX_ELEMENT = "Index";
    static final public String INDEX_LOW_STR = "index";
    static final public String INDEX_DEFAULT_ELEMENT = "DefaultIndex";
    static final public String INDEX_DEFAULT_ELEMENT_LOWERCASE = "defaultIndex";
    static final public String INDEX_DEFAULT_STR = "defaultindex";
    static final public String INDEX_STR = "indexes";
    static final public String INDEXES_ELEMENT = "Indexes";
    static final public String INDEXOPTION_ELEMENT = "Option";
    static final public String INDEXOPTIONS_ELEMENT = "IndexOption";
    static final public String INDEXOPTION_STR = "indexOption";
    static final public String INDEXOPTIONS_STR = "indexoptions";
    static final public String INDEXOPTION_DEFAULT_ELEMENT = "DefaultIndexOption";
    static final public String INFODB_STR = "infodb";
    static final public String INT_STR = "int";
    static final public String IMPORT_STR = "import";
  static final public String IMPORT_OPTION_STR = "importOption";
  static final public String BUILD_OPTION_STR = "buildOption";
  
    static final public String[] KEEP_PLUG = { "GreenstoneXMLPlugin", "GreenstoneMETSPlugin", "EmbeddedMetadataPlugin" };
    static final public String KEY_ATTRIBUTE = "key";
    static final public String LANGUAGE_ARGUMENT = "l=";
    static final public String LANGUAGE_ATTRIBUTE = "language";
    static final public String LANGUAGE_ELEMENT = "Language";
    static final public String LANGUAGE_DEFAULT_ELEMENT = "DefaultLanguage";
    static final public String LANGUAGE_DEFAULT_INDEX_ELEMENT = "defaultIndexLanguage";
    static final public String LANGUAGE_DEFAULT_STR = "defaultlanguage";
    static final public String LANGUAGE_INDEX_ELEMENT = "indexLanguage";
    static final public String LANGUAGE_METADATA_ELEMENT = "LanguageMetadata";
    static final public String LANGUAGE_METADATA_ELEMENT_STR = "languageMetadata";
    static final public String LANGUAGE_METADATA_STR = "languagemetadata";
    static final public String LANG_STR = "lang";
    static final public String LANG_ATTRIBUTE = "lang";
    static final public String LANGUAGE_STR = "language";
    static final public String LANGUAGES_ELEMENT = "Languages";
    static final public String LANGUAGES_STR = "languages";
    static final public String LBRACKET_CHARACTER = "[";
    static final public String LESS_THAN_CHARACTER = "<";
    static final public String LEVEL_ATTRIBUTE = "level";
    static final public String LEVEL_ELEMENT = "level";
    static final public String LEVEL_DEFAULT_ELEMENT = "defaultLevel";
    static final public String LEVEL_DEFAULT_STR = "defaultlevel";
    static final public String LEVELS_STR = "levels";
    static final public String LIBRARY_URL_ARGUMENT = "-library_url";
    static public String LINUX_OPEN_COMMAND; // can't be final, set conditionally in FileAssociationManager
    // to one of xdg-open/kde-open/gnome-open whichever worked, or "" if none
    static final public String LOCAL_LIBRARY_ARGUMENT = "-local_library";
    static final public String LOAD_ARGUMENT = "-load";
    static final public String MAC_OPEN_COMMAND = "open %1";
    static final public String MAPPING_ELEMENT = "Mapping";
    static final public String MDS_ATTRIBUTE = "mds";
    static final public String METADATA_ARGUMENT = "-metadata";
    static final public String METADATA_ELEMENT = "Metadata";
    static final public String METADATA_SET_EXTENSION = ".mds";
    static final public String METADATA_STR = "metadata";
    static final public String METADATALIST_STR = "metadataList";
    static final public String METADATALIST_ELEMENT = "MetadataList";
    static final public String METADATA_TYPE_STR = "metadata";
    static final public String METADATA_XML = "metadata.xml";
    static final public String METADATAXMLPLUG_STR = "MetadataXMLPlugin";
    static final public String MGPP_ATTRIBUTE = "mgpp_enabled";
    static final public String MINUS_CHARACTER = "-";
    static final public String MODE_STR = "Mode: ";
    static final public String MODEL_COLLECTION_NAME = "modelcol";
    static final public String MODEL_SITE_NAME = "modelsite";
    static final public String NAME_ATTRIBUTE = "name";
    static final public String NAME_STR = "name";
    static final public String NAME_ELEMENT = "Name";
    static final public String NEWLINE_CHARACTER = "\\";
    static final public String NO_LOAD_ARGUMENT = "-no_load";
    static final public String NONE_STR = "none";
    static final public String ONE_CHARACTER = "1";
    static final public String OPEN_PARENTHESIS_CHARACTER = "(";
    static final public String OPTION_ELEMENT = "Option";
    static final public String OPTION_STR = "option";

    static final public String OPTIONS_ATTRIBUTE = "options";
    static final public String PARAGRAPH_STR = "paragraph";
    static final public String PERL_ARGUMENT = "-perl";
    static final public String PHIND_CLASSIFIER = "Phind";
    static final public String PLUGIN_ELEMENT = "Plugin";
    static final public String PLUGIN_STR = "plugin";
    static final public String PLUGINLIST_STR = "pluginList";
    static final public String PLUGOUT_STR = "plugout";
    static final public String PREDEFINED_METADATA_ATTRIBUTE = "predefined";
    static final public String RANK_STR = "rank";
    static final public String RBRACKET_CHARACTER = "]";
    static final public String RECPLUG_STR = "DirectoryPlugin";
    static final public String REGEXP_STR = "regexp";
  static final public String REPLACELIST_STR = "replaceList";
    static final public String REPLACELISTREF_STR = "replaceListRef";
    static final public String RESTRICTED_METADATA_ATTRIBUTE = "restricted";
    static final public String SEARCHTYPE_ELEMENT = "searchType";
    static final public String SEARCHTYPE_STR = "searchtype";
    static final public String SEARCH_STR = "search";
  static final public String SECURITY_STR = "security";
    static final public String SECTION_ELEMENT = "Section";
    static final public String SECTION_STR = "section";
    static final public String SEPARATE_CJK_OPTION_STR = "separate_cjk";
    static final public String SEPARATOR_ATTRIBUTE = "separator";
    static final public String SEPARATOR_CHARACTER = "/";
	static final public String SERVICE_RACK_LIST_ELEMENT = "serviceRackList";
    static final public String SERVLET_ARGUMENT ="-servlet_path";
    static final public String SINGLE_QUOTE_CHARACTER = "'";
    static final public String SITE_ARGUMENT = "-site";
    static final public String SMALLICON_STR = "smallicon";
    static final public String SOLR_ELEMENT = "Solr";
    static final public String SORT_ELEMENT = "Sort";
    static final public String SORTS_ELEMENT = "Sorts";
    static final public String SORT_LOW_STR = "sort";
    static final public String SORT_DEFAULT_ELEMENT = "defaultSort";
    static final public String SORT_STR = "sortfields";
    static final public String SORT_DEFAULT_STR = "defaultsort";
    static final public String SPACE_CHARACTER = " ";
    static final public String SPECIAL_ATTRIBUTE = "special";
    static final public String SPEECH_CHARACTER = "\"";
    static final public String STEM_OPTION_STR = "stem";
    static final public String STOP_CHARACTER = ".";
    static final public String SUBCOLLECTION_ELEMENT = "Subcollection";
    static final public String SUBCOLLECTION_STR = "subcollection";
    static final public String SUBCOLLECTION_DEFAULT_INDEX_ELEMENT = "DefaultSubcollection";
    static final public String SUBCOLLECTION_DEFAULT_INDEX_STR = "defaultsubcollection";
    static final public String SUBCOLLECTION_INDEX_STR = "indexsubcollections";
    static final public String SUBCOLLECTION_INDEX_ELEMENT = "indexSubcollection";
    static final public String SUBCOLLECTION_INDEXES_ELEMENT = "SubcollectionIndexes";
    static final public String SUPERCOLLECTION_ELEMENT = "Supercollection";
    static final public String SUPERCOLLECTION_STR = "supercollection";
    static final public String TAB_CHARACTER = "\t";
    static final public String TEXT_NODE = "#text";
    static final public String TEXT_STR = "text";
    static final public String TESTING_ARGUMENT = "-testing_mode";
    static final public String TIMESTAMP_ARGUMENT = "&uq=";
    static final public String TITLE_ELEMENT = "Title";
    static final public String SOURCE_ELEMENT = "Source";
    static final public String TRUE_STR = "true";
    static final public String TYPE_ATTRIBUTE = "type";
    static final public String UNKNOWN_ELEMENT = "Unknown";
    static final public String UNKNOWNPLUG_STR = "UnknownPlugin";
    static final public String USE_METADATA_FILES_ARGUMENT = "use_metadata_files";
    static final public String USE_REMOTE_GREENSTONE_ARGUMENT = "-use_remote_greenstone";
    static final public String USERNAME_ARGUMENT = "-username";
    static final public String USERGROUPS_ARGUMENT = "-groups";
    static final public String USERID_ARGUMENT = "-uid";
    static final public String WEBSWING_ARGUMENT = "-webswing";    
    static final public String URL_SEPARATOR_CHARACTER = "/";
    static final public String VALUE_ATTRIBUTE = "value";
    static final public String VERSION_ATTRIBUTE = "version";
    static final public String WIN_9X_OPEN_COMMAND = "command.com /c start \"%1\"";
    static final public String WIN_OPEN_COMMAND = "cmd.exe /c start \"\" \"%1\"";
    static final public String YES_STR = "yes";
    static final public String ZERO_CHARACTER = "0";
    static final public String METADATA_PATH                              = "-metadata_path";
    static final public String NEW_METADATASET                            = "-new_set";
    static final public String CACHE_FOLDER                               = "cache";
    static final public String CUSTOM_ATTRIBUTE                           = "custom";
    static final public String MG_STR                           = "mg";
    static final public String MGPP_STR                           = "mgpp";
    static final public String LUCENE_STR                           = "lucene";
    static final public String SOLR_STR = "solr";
    
}
