/**
 *############################################################################
 * A component of the Greenstone Librarian Interface, part of the Greenstone
 * digital library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * Author: Michael Dewsnip, NZDL Project, University of Waikato, NZ
 *
 * Copyright (C) 2004 New Zealand Digital Library Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *############################################################################
 */

package org.greenstone.gatherer.metadata;


import java.io.*;
import java.util.*;
import org.greenstone.gatherer.util.XMLTools;


/** This class is a static class that manages the profile.xml file */
public class ProfileXMLFileManager
{
    static private ProfileXMLFile profile_xml_file = null;


    static public void clearProfileXMLFile()
    {
	profile_xml_file = null;
    }


    static public void loadProfileXMLFile(File directory)
    {
	// Make sure the directory (metadata) exists
	if (directory.exists() == false) {
	    directory.mkdir();
	}

	File profile_xml_file_file = new File(directory, "profile.xml");
	if (!profile_xml_file_file.exists()) {
	    // Create a new (empty) profile.xml file in this directory...
	    XMLTools.writeXMLFile(profile_xml_file_file, XMLTools.parseXMLFile("xml/profile.xml", true));
	}

	profile_xml_file = new ProfileXMLFile(profile_xml_file_file.getAbsolutePath());
    }


    static public String getMetadataElementFor(String metadata_element_name_full)
    {
	if (profile_xml_file == null) {
	    return null;
	}

	return profile_xml_file.getMetadataElementFor(metadata_element_name_full);
    }


    static public HashMap getMetadataMapping()
    {
	if (profile_xml_file == null) {
	    return null;
	}

	return profile_xml_file.getMetadataMapping();
    }


    static public void mapElement(String metadata_element_name_full, String target_metadata_element_name_full)
    {
	if (profile_xml_file != null) {
	    profile_xml_file.mapElement(metadata_element_name_full, target_metadata_element_name_full);
	}
    }
}
