/**
 *############################################################################
 * A component of the Greenstone Librarian Interface, part of the Greenstone
 * digital library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * Author: Michael Dewsnip, NZDL Project, University of Waikato, NZ
 *
 * Copyright (C) 2005 New Zealand Digital Library Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *############################################################################
 */

package org.greenstone.gatherer.greenstone;


import java.io.*;


/**
 * This class contains static functions that only make sense when running with a local Greenstone.
 * None of these functions should be called if the GLI is using a remote Greenstone.
 */
public class LocalGreenstone
{
    static private String gsdl_directory_path = null;


    static public String getBinScriptDirectoryPath()
    {
	return gsdl_directory_path + "bin" + File.separator + "script" + File.separator;
    }
    
    static public String getBinOSDirectoryPath(String operatingSystem)
    {
	return gsdl_directory_path + "bin" + File.separator + operatingSystem + File.separator;
    }
    

    static public String getDirectoryPath()
    {
	return gsdl_directory_path;
    }


    static public String getTmpDirectoryPath()
    {
	return gsdl_directory_path + "tmp" + File.separator;
    }


    static public void setDirectoryPath(String gsdl_directory_path_arg)
    {
	gsdl_directory_path = gsdl_directory_path_arg;
    }
}
