#!/bin/bash

if [ "x$GSDL3SRCHOME" = "x" ] ; then
    pushd ../../..
    . ./gs3-setup-cli.sh
    . ./gs3-setup.sh
    popd
fi

if [ ! -d "$GSDL3SRCHOME/web/ext/webswing" ] ; then
    echo "Creating directories:"
    echo "    $GSDL3SRCHOME/web/ext/webswing"
    echo "    $GSDL3SRCHOME/web/ext/webswing/etc"    
    
    mkdir "$GSDL3SRCHOME/web/ext/webswing"
    mkdir "$GSDL3SRCHOME/web/ext/webswing/etc"
fi

for f in catalina-opts-extra.args webswing.properties webswing.config ; do
    
    echo "Copying etc/$f.in => \$GSDL3SRCHOME/web/ext/webswing/etc/$f"
    cat etc/$f.in \
	| sed "s|@gsdl3srchome@|$GSDL3SRCHOME|g" \
	> $GSDL3SRCHOME/web/ext/webswing/etc/$f
done


for d in api fonts ssl ; do
    echo "Copying $d/ => \$GSDL3SRCHOME/web/ext/webswing/."
    /bin/cp -r $d $GSDL3SRCHOME/web/ext/webswing/.
done

echo "Copying webswing-server.war => \GSDL3SRCHOME/packages/tomcat/webapps/."
/bin/cp webswing-server.war $GSDL3SRCHOME/packages/tomcat/webapps/.
