
extdesc="the Solr Extension"

full_setup=`pwd`/${BASH_SOURCE}
fulldir=${full_setup%/*}
fulldir=${fulldir%/.}

#--
# Edit the following two port values if they conflict with
# with existing services on your computer
#--

# If using tomcat, read the tomcat host and port from the toplevel GS3 build.properties
# http://en.kioskea.net/faq/1757-how-to-read-a-file-line-by-line
# The following sets the field separator IFS to the = sign, then reads the file line by 
# line, setting propname and propval (which are fields separated by '=') for each line read
SOLR_PORT=8383
SOLR_HOST=127.0.0.1
file=$GSDL3SRCHOME/build.properties
# The Solr servlet should only be locally accessible, thus restricting the protocol to http as
# https certificates can't be issued for localhost/127.0.0.1 (https://letsencrypt.org/docs/certificates-for-localhost/)
# This means we use the properties localhost.server.http (defaults to 127.0.0.1) and localhost.port.http 
# to construct the solr servlet url, rather than properties tomcat.server and tomcat.port.https
while IFS== read propname propval; do
    if [ "x$propname" = "xlocalhost.server.http" ] ; then
	SOLR_HOST=$propval
    fi
    if [ "x$propname" = "xlocalhost.port.http" ] ; then
	SOLR_PORT=$propval
    fi          
done < $file


if test -z $GSDLOS ; then
  GSDLOS=`uname -s | tr '[A-Z]' '[a-z]'`
  # check for running bash under Cygwin
  if test "`echo $GSDLOS | sed 's/cygwin//'`" != "$GSDLOS" ;
  then
    GSDLOS=windows
  fi
  # check for running bash under MinGW/MSys
  if test "`echo $GSDLOS | sed 's/mingw//'`" != "$GSDLOS" ;
  then
    GSDLOS=windows
  fi
  echo "GSDLOS was not set.  Setting it to '$GSDLOS'"
  export GSDLOS
fi
	
#first_time=0;

if [ "x$GEXT_SOLR" = "x" ] ; then
  export GEXT_SOLR=`pwd`

  if [ -d "$GEXT_SOLR/bin/script" ] ; then
    export PATH=$GEXT_SOLR/bin/script:$PATH
  fi

  if [ -d "$GEXT_SOLR/lib" ] ; then
    if [ "$GSDLOS" = "linux" ] ; then
      export LD_LIBRARY_PATH=$GEXT_SOLR/lib:$LD_LIBRARY_PATH
    elif [ "$GSDLOS" = "darwin" ] ; then
      export DYLD_LIBRARY_PATH=$GEXT_SOLR/lib:$DYLD_LIBRARY_PATH
    fi
  fi

  extdir=${GEXT_SOLR##*/}

  if [ "x$GSDL3EXTS" = "x" ] ; then
    export GSDL3EXTS=$extdir
  else 
    export GSDL3EXTS=$GSDL3EXTS:$extdir
  fi

  export SOLR_PORT
  export SOLR_HOST
#  first_time=1

  echo "+Your environment is now setup for $extdesc"
else
  echo "+Your environment is already setup for $extdesc"
fi

echo "  - Solr API accessed internally via: http://$SOLR_HOST:$SOLR_PORT/solr/"


#if [ "$first_time" = "1" ] ; then
#  echo "++Solr will run off the tomcat server on port $SOLR_PORT. "
#  echo "-- This port value can be changed by editing tomcat.port in build.properties"
#  echo ""
#fi
