@echo off
pushd "%CD%"
CD /D "%~dp0"

set extdesc=the Solr Extension
if "%GSDL3SRCHOME%" == "" echo Run the toplevel gs3-setup.bat before calling this script& goto End

rem IF USING TOMCAT SERVER FOR SOLR
:: If using tomcat, read the tomcat host and port from the toplevel GS3 build.properties
:: http://en.kioskea.net/faq/1757-how-to-read-a-file-line-by-line
:: The following reads build.properties line by line, tokenizing it around the = sign, then
:: sets the SOLR_PORT and SOLR_HOST to the values of tomcat.port and tomcat.host properties

set SOLR_PORT=8383
set SOLR_HOST=127.0.0.1

setlocal enabledelayedexpansion
set FOUNDPROPS=
:: The Solr servlet should only be locally accessible, thus restricting the protocol to http as
:: https certificates can't be issued for localhost/127.0.0.1 (https://letsencrypt.org/docs/certificates-for-localhost/)
:: This means we use the properties localhost.server.http (defaults to 127.0.0.1) and localhost.port.http 
:: to construct the solr servlet url, rather than properties tomcat.server and tomcat.port.https
:: Loosely based on 
:: http://stackoverflow.com/questions/7708681/how-to-read-from-a-properties-file-using-batch-script 
:: for with usebackq option allows spaces in filepath to be protected with double quotes 
:: (backquotes will be used for executing the commands)
:: See also https://stackoverflow.com/questions/5553040/batch-file-for-loop-with-spaces-in-dir-name
:: for alternative suggestions useful in other instances
FOR /F "usebackq tokens=1,2 delims==" %%G IN ("%GSDL3SRCHOME%\build.properties") DO ( 
	if "%%G"=="localhost.server.http" set SOLR_HOST=%%H& set FOUNDPROPS=!FOUNDPROPS!found
	if "%%G"=="localhost.port.http" set SOLR_PORT=%%H& set FOUNDPROPS=!FOUNDPROPS!found
	:: break out of the loop as soon as both properties are found
	if "!FOUNDPROPS!" == "foundfound" goto foundall
)

:foundall
endlocal& set SOLR_HOST=%SOLR_HOST%& set SOLR_PORT=%SOLR_PORT%
echo   - Solr API accessed internally via: http://%SOLR_HOST%:%SOLR_PORT%/solr/

if "%OS%" == "Windows_NT" goto WinNT
if "%OS%" == "" goto Win95
if "%GSDLLANG%" == "en" echo Setup failed - your PATH has not been set
if "%GSDLLANG%" == "es" echo No se pudo realizar la configuracin - no se ha establecido la RUTA.
if "%GSDLLANG%" == "fr" echo Echc de l'installation - votre variable PATH n'a pas t ajuste
if "%GSDLLANG%" == "ru" echo ⁠  つ -   끫 ⁠
goto End

:WinNT
set GEXT_SOLR=%CD%
set PATH=%GEXT_SOLR%\bin\script;%PATH%
set PATH=%GEXT_SOLR%\lib;%PATH%
set GS_CP_SET=yes
goto Success

:Win95
if "%1" == "SetEnv" goto Win95Env
REM We'll invoke a second copy of the command processor to make
REM sure there's enough environment space
COMMAND /E:2048 /K %0 SetEnv
goto End

:Win95Env
set GEXT_SOLR=%CD%
set PATH="%GEXT_SOLR%\bin\script";"%PATH%"
set PATH="%GEXT_SOLR%\lib";"%PATH%"
set GS_CP_SET=yes
goto Success

:Success

set fulldir=%~dp0

:: strip off everything up to (and including) ext dir
set extdir=%fulldir:*ext\=%

:: remove trailing slash
set extdir=%extdir:\=%

setlocal enabledelayedexpansion
if "x%GSDL3EXTS%" == "x" (
  set GSDL3EXTS=!extdir!
) else (
  set GSDL3EXTS=!GSDL3EXTS!:!extdir!
)
endlocal & set GSDL3EXTS=%GSDL3EXTS%

:: Back to delayed expansion to avoid problems with environment
:: variables with brackets in them, such as "Program Files (x86)"

echo +Your environment is now setup for %extdesc%

:End

popd
