@echo off

setlocal

set OS_ALLCAPS=WINDOWS

set selfcon_ext=selfcontained-perl-with-cpan
set installed_dir=%selfcon_ext%\gsperl5-with-cpan-windows

echo.
cmd /c .\get-subversion-windows-64bit.bat
cmd /c .\setup-subversion-windows-64bit.bat

echo.

if not exist %selfcon_ext% (
    echo Checking out from svn: Greenstone3\'s %selfcon_ext% extension
    svn co https://svn.greenstone.org/gs3-extensions/%selfcon_ext%/trunk %selfcon_ext%

    if %ERRORLEVEL% NEQ 0 (	
	echo Error encountered checking out:  1>&2
	echo     svn co https://svn.greenstone.org/gs3-extensions/%selfcon_ext%/trunk %selfcon_ext% 1>&2
	exit /b 1
    )
) else (
    echo Detected directory '%selfcon_ext%'
    echo =^> Taken to mean that the svn check-out command has already been run
)

echo.
if not exist %installed_dir% (
    echo Running the %selfcon_ext%\PREPARE-%OS_ALLCAPS%.bat

    cd %selfcon_ext% && call .\PREPARE-%OS_ALLCAPS%.bat

    if %ERRORLEVEL% NEQ 0 (    
	echo Error encountered running: 1>&2
	echo     cd %selfcon_ext% && .\PREPARE-%OS_ALLCAPS%.bat 1>&2
	exit /b 1
    )
	
) else (
    echo Detected directory '%installed_dir%'
    echo =^> Taken to mean that the %selfcon_ext%/PREPARE-%OS_ALLCAPS%.bat command has already been run
)


if not "x%GSPERL_WITH_CPAN_HOME%" == "x%CD%\%installed_dir%" (
    echo.
    echo To use this installed version of Perl, in the top-level Greenstone3 directory run:
    echo     gs3-setup-cli.bat
    echo.
) else (
    echo.
    echo Detected GSPERL_WITH_CPAN_HOME set to %CD%\%installed_dir%
    echo =^> Taken to mean that the %selfcon_ext% SETUP.bat file has been sourced
)

echo.


endlocal
