@echo off

setlocal

set OS_ALLCAPS=WINDOWS

set selfcon_ext=selfcontained-ant
set installed_dir=%selfcon_ext%\apache-ant

echo.
cmd /c .\get-subversion-windows-64bit.bat
cmd /c .\setup-subversion-windows-64bit.bat

echo.

if not exist selfcontained-jdk (
    echo.
    echo Checking for java ...
    REM java -version > nul 2> nul
    where java > nul 2> nul
    
    if %ERRORLEVEL% NEQ 0 (
	echo.
	echo Failed to find 'java'
	echo After 5 seconds, initiating:
	echo.
	echo     .\get-selfcontained-jdk.bat
	echo [Press ^C to stop]
	timeout /t 5 /nobreak >nul 
	.\get-selfcontained-jdk.bat
    ) else (
	echo.
	echo Detected 'java' but it is not the Greenstone3 supplied 'selfcontained-jdk'
	echo => Recommend running:
	echo.
	echo     .\get-selfcontained-jdk.bat
	echo.
	echo After 5 seconds, continuing with getting ant
	echo [Press ^C to stop]
	timeout /t 5 /nobreak >nul	
    )
)



echo.
if not exist %selfcon_ext% (
    echo Checking out from svn: Greenstone3\'s %selfcon_ext% extension
    svn co https://svn.greenstone.org/gs3-extensions/%selfcon_ext%/trunk %selfcon_ext%

    if %ERRORLEVEL% NEQ 0 (	
	echo Error encountered checking out:  1>&2
	echo     svn co https://svn.greenstone.org/gs3-extensions/%selfcon_ext%/trunk %selfcon_ext% 1>&2
	exit /b 1
    )
) else (
    echo Detected directory '%selfcon_ext%'
    echo =^> Taken to mean that the svn check-out command has already been run
)

echo.
if not exist %installed_dir% (
    echo Runing the %selfcon_ext%\PREPARE-%OS_ALLCAPS%.bat

    cd %selfcon_ext% && call .\PREPARE-%OS_ALLCAPS%.bat

    if %ERRORLEVEL% NEQ 0 (    
	echo Error encountered running: 1>&2
	echo     cd %selfcon_ext% && .\PREPARE-%OS_ALLCAPS%.bat 1>&2
	exit /b 1
    )
	
) else (
    echo Detected directory '%installed_dir%'
    echo =^> Taken to mean that the %selfcon_ext%/PREPARE-%OS_ALLCAPS%.bat command has already been run
)


rem if "x%ANT_HOME%" NEQ "x%CD%\%installed_dir%" (
if not "x%ANT_HOME%" == "x%CD%\%installed_dir%" (
    echo.
    echo To use this installed version of Apache Ant, in the top-level Greenstone3 directory run:
    echo     gs3-setup-cli.bat
    echo.
) else (
    echo.
    echo Detected ANT_HOME set to %CD%\%installed_dir%
    echo =^> Taken to mean that the %selfcon_ext% SETUP.bat file has been sourced
)

echo.


endlocal
