/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2.lucene;

import company.evo.jmorphy2.Grammeme;
import company.evo.jmorphy2.MorphAnalyzer;
import company.evo.jmorphy2.ParsedWord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.AttributeSource;

public class Jmorphy2StemFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final KeywordAttribute keywordAtt = (KeywordAttribute)this.addAttribute(KeywordAttribute.class);
    private final MorphAnalyzer morph;
    private final List<Set<Grammeme>> includeGrammemes;
    private final List<Set<Grammeme>> excludeGrammemes;
    private final boolean enablePositionIncrements;
    private Iterator<String> normalForms = null;
    private AttributeSource.State savedState = null;
    private boolean first = true;
    private int skippedPositions = 0;

    public Jmorphy2StemFilter(TokenStream input, MorphAnalyzer morph) {
        this(input, morph, null, null, true);
    }

    public Jmorphy2StemFilter(TokenStream input, MorphAnalyzer morph, List<Set<String>> includeTags) {
        this(input, morph, includeTags, null, true);
    }

    public Jmorphy2StemFilter(TokenStream input, MorphAnalyzer morph, List<Set<String>> includeTags, List<Set<String>> excludeTags) {
        this(input, morph, includeTags, excludeTags, true);
    }

    public Jmorphy2StemFilter(TokenStream input, MorphAnalyzer morph, List<Set<String>> includeTags, List<Set<String>> excludeTags, boolean enablePositionIncrements) {
        super(input);
        this.morph = morph;
        this.includeGrammemes = this.convertValuesToGrammemes(includeTags);
        this.excludeGrammemes = this.convertValuesToGrammemes(excludeTags);
        this.enablePositionIncrements = enablePositionIncrements;
    }

    private List<Set<Grammeme>> convertValuesToGrammemes(List<Set<String>> valuesSets) {
        if (valuesSets == null) {
            return null;
        }
        ArrayList<Set<Grammeme>> grammemesSets = new ArrayList<Set<Grammeme>>();
        for (Set<String> valueSet : valuesSets) {
            HashSet<Grammeme> grammemeSet = new HashSet<Grammeme>();
            for (String value : valueSet) {
                grammemeSet.add(this.morph.getGrammeme(value));
            }
            if (grammemeSet.isEmpty()) continue;
            grammemesSets.add(grammemeSet);
        }
        return grammemesSets;
    }

    public void reset() throws IOException {
        super.reset();
        this.normalForms = null;
        this.first = true;
        this.skippedPositions = 0;
    }

    public final boolean incrementToken() throws IOException {
        if (this.normalForms == null || !this.normalForms.hasNext()) {
            this.skippedPositions = 0;
            while (this.input.incrementToken()) {
                if (this.keywordAtt.isKeyword()) {
                    return true;
                }
                this.normalForms = this.getNormalForms(this.termAtt).iterator();
                if (this.normalForms.hasNext()) {
                    this.setTerm(this.normalForms.next(), this.posIncAtt.getPositionIncrement());
                    if (this.normalForms.hasNext()) {
                        this.savedState = this.captureState();
                    }
                    this.skippedPositions = 0;
                    return true;
                }
                this.skippedPositions += this.posIncAtt.getPositionIncrement();
            }
            return false;
        }
        this.restoreState(this.savedState);
        this.setTerm(this.normalForms.next(), 0);
        return true;
    }

    private List<String> getNormalForms(CharTermAttribute termAtt) throws IOException {
        ArrayList<String> normalForms = new ArrayList<String>();
        HashSet<String> uniqueNormalForms = new HashSet<String>();
        char[] termBuffer = termAtt.buffer();
        int termLength = termAtt.length();
        String token = new String(termBuffer, 0, termLength);
        List parseds = this.morph.parse(token);
        for (ParsedWord p : parseds) {
            boolean shouldAdd = false;
            if (this.includeGrammemes != null) {
                for (Set<Grammeme> includeGrammemeSet : this.includeGrammemes) {
                    if (!p.tag.containsAll(includeGrammemeSet)) continue;
                    shouldAdd = true;
                    break;
                }
            } else if (this.excludeGrammemes != null) {
                boolean shouldExclude = false;
                for (Set<Grammeme> excludeGrammemeSet : this.excludeGrammemes) {
                    if (!p.tag.containsAll(excludeGrammemeSet)) continue;
                    shouldExclude = true;
                    break;
                }
                if (!shouldExclude) {
                    shouldAdd = true;
                }
            } else {
                shouldAdd = true;
            }
            if (!shouldAdd || uniqueNormalForms.contains(p.normalForm)) continue;
            normalForms.add(p.normalForm);
            uniqueNormalForms.add(p.normalForm);
        }
        return normalForms;
    }

    private void setTerm(String stem, int posInc) {
        this.termAtt.copyBuffer(stem.toCharArray(), 0, stem.length());
        this.termAtt.setLength(stem.length());
        if (this.enablePositionIncrements) {
            this.posIncAtt.setPositionIncrement(posInc + this.skippedPositions);
        } else if (this.first) {
            if (posInc == 0) {
                this.posIncAtt.setPositionIncrement(1);
            }
            this.first = false;
        } else {
            this.posIncAtt.setPositionIncrement(posInc);
        }
    }
}

