/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.common.model.meta;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.common.model.Config;
import org.webswing.server.common.model.meta.ConfigContext;
import org.webswing.server.common.model.meta.ConfigField;
import org.webswing.server.common.model.meta.ConfigFieldDiscriminator;
import org.webswing.server.common.model.meta.ConfigFieldEditorType;
import org.webswing.server.common.model.meta.ConfigFieldOrder;
import org.webswing.server.common.model.meta.ConfigFieldPresets;
import org.webswing.server.common.model.meta.ConfigFieldVariables;
import org.webswing.server.common.model.meta.ConfigGroup;
import org.webswing.server.common.model.meta.ConfigType;
import org.webswing.server.common.model.meta.MetaField;
import org.webswing.server.common.model.meta.MetaObject;
import org.webswing.server.common.model.meta.VariableSetName;
import org.webswing.server.common.util.ConfigUtil;

public class MetadataGenerator<T> {
    private static final Logger log = LoggerFactory.getLogger(MetadataGenerator.class);
    private static final List<ConfigFieldEditorType.EditorType> TABLE_COMPATIBLE_TYPES = Arrays.asList(ConfigFieldEditorType.EditorType.String, ConfigFieldEditorType.EditorType.Number, ConfigFieldEditorType.EditorType.Boolean, ConfigFieldEditorType.EditorType.StringList);
    private ConfigContext context;

    public MetaObject getMetadata(T config, ClassLoader cl) throws Exception {
        MetadataGenerator<T> generator = this.findGenerator(config);
        return generator.getMetadata(config, cl, null);
    }

    protected MetaObject getMetadata(T config, ClassLoader cl, Object parent) throws Exception {
        MetaObject metaObj = new MetaObject();
        if (config != null) {
            ArrayList<MetaField> metaFields = new ArrayList<MetaField>();
            LinkedHashSet<String> properties = this.getPropertyNames(config, cl);
            for (String propertyName : properties) {
                MetaField meta = this.getPropertyMetadata(config, cl, propertyName);
                if (meta == null) continue;
                metaFields.add(meta);
            }
            metaObj.setFields(metaFields);
        }
        return metaObj;
    }

    protected LinkedHashSet<String> getPropertyNames(T config, ClassLoader cl) throws Exception {
        PropertyDescriptor[] pds;
        LinkedHashSet<String> properties = new LinkedHashSet<String>();
        BeanInfo info = Introspector.getBeanInfo(config.getClass());
        for (PropertyDescriptor field : pds = info.getPropertyDescriptors()) {
            ConfigField configField;
            String fieldName = field.getName();
            Method readMethod = field.getReadMethod();
            if (readMethod == null || (configField = ConfigUtil.findAnnotation(readMethod, ConfigField.class)) == null) continue;
            properties.add(fieldName);
        }
        ConfigFieldOrder fieldOrder = MetadataGenerator.findAnnotation(config.getClass(), ConfigFieldOrder.class);
        if (fieldOrder != null) {
            LinkedHashSet<String> order = new LinkedHashSet<String>(Arrays.asList(fieldOrder.value()));
            properties.removeAll(order);
            order.addAll(properties);
            return order;
        }
        return properties;
    }

    protected MetaField getPropertyMetadata(T config, ClassLoader cl, String propertyName) throws Exception {
        PropertyDescriptor[] pds;
        BeanInfo info = Introspector.getBeanInfo(config.getClass());
        for (PropertyDescriptor field : pds = info.getPropertyDescriptors()) {
            ConfigField configField;
            Method readMethod;
            String fieldName = field.getName();
            if (!fieldName.equals(propertyName) || (readMethod = field.getReadMethod()) == null || (configField = ConfigUtil.findAnnotation(readMethod, ConfigField.class)) == null) continue;
            try {
                Object value = this.getValue(config, cl, propertyName, readMethod);
                MetaField metadata = new MetaField();
                this.setMetadataProperties(metadata, fieldName, config, cl, propertyName, readMethod, value, false);
                return metadata;
            }
            catch (Exception e) {
                log.error("Failed to generate metadata for field '" + fieldName + "' in object " + config.getClass().getName(), e);
                MetaField metadata = new MetaField();
                this.setMetadataProperties(metadata, fieldName, config, cl, propertyName, readMethod, null, true);
                return metadata;
            }
        }
        return null;
    }

    private void setMetadataProperties(MetaField metadata, String fieldName, T config, ClassLoader cl, String propertyName, Method readMethod, Object value, boolean safeMode) throws Exception {
        metadata.setName(fieldName);
        metadata.setTab(this.getTab(config, cl, propertyName, readMethod));
        metadata.setLabel(this.getLabel(config, cl, propertyName, readMethod));
        metadata.setDescription(this.getDescription(config, cl, propertyName, readMethod));
        metadata.setVariables(this.isVariables(config, cl, propertyName, readMethod));
        metadata.setDiscriminator(this.isDiscriminator(config, cl, propertyName, readMethod));
        metadata.setPresets(this.getPresets(config, cl, propertyName, readMethod));
        if (safeMode) {
            metadata.setType(ConfigFieldEditorType.EditorType.Generic);
            metadata.setValue(this.getSafeValue(config, readMethod));
        } else {
            metadata.setType(this.getEditorType(config, cl, propertyName, readMethod));
            if (ConfigFieldEditorType.EditorType.ObjectListAsTable.equals((Object)metadata.getType())) {
                metadata.setTableColumns(this.getColumnsDefinitions(config, cl, propertyName, readMethod));
            }
            metadata.setValue(value);
        }
    }

    protected List<MetaField> getColumnsDefinitions(T config, ClassLoader cl, String propertyName, Method readMethod) throws Exception {
        Class<?> type = MetadataGenerator.getReturnTypeGeneric(readMethod, 0);
        Object instance = ConfigUtil.instantiateConfig(null, type, new Object[0]);
        MetaObject metaobject = this.toMetaObject(config, cl, instance, type);
        ArrayList<MetaField> result = new ArrayList<MetaField>();
        for (MetaField field : metaobject.getFields()) {
            if (!TABLE_COMPATIBLE_TYPES.contains((Object)field.getType())) continue;
            result.add(field);
        }
        return result;
    }

    protected Object getSafeValue(T config, Method readMethod) {
        Object value;
        try {
            value = readMethod.invoke(config, new Object[0]);
        }
        catch (Exception e) {
            value = null;
        }
        return value;
    }

    protected Object getValue(T config, ClassLoader cl, String propertyName, Method readMethod) throws Exception {
        Object value = readMethod.invoke(config, new Object[0]);
        if (value == null) {
            return null;
        }
        ConfigFieldEditorType.EditorType type = this.getEditorType(config, cl, propertyName, readMethod);
        switch (type) {
            case Generic: {
                return value;
            }
            case Boolean: {
                return (Boolean)value;
            }
            case Number: {
                return (Number)value;
            }
            case String: {
                return value instanceof String ? value : value.toString();
            }
            case LongString: {
                return value instanceof String ? value : value.toString();
            }
            case StringList: {
                return (List)value;
            }
            case StringMap: {
                return (Map)value;
            }
            case Object: {
                return this.getMetaObject(config, cl, propertyName, readMethod, value);
            }
            case ObjectList: {
                return this.getMetaObjectList(config, cl, propertyName, readMethod, (List)value);
            }
            case ObjectListAsTable: {
                return (List)value;
            }
            case ObjectMap: {
                return this.getMetaObjectMap(config, cl, propertyName, readMethod, (Map)value);
            }
        }
        return null;
    }

    protected MetaObject getMetaObject(T config, ClassLoader cl, String propertyName, Method readMethod, Object value) throws Exception {
        Class<?> type = this.getExplicitType(config, cl, propertyName, readMethod, value);
        if (type == null) {
            type = readMethod.getReturnType();
        }
        MetaObject meta = this.toMetaObject(config, cl, value, type);
        return meta;
    }

    protected List<MetaObject> getMetaObjectList(T config, ClassLoader cl, String propertyName, Method readMethod, List<?> value) throws Exception {
        Class<?> type = this.getExplicitType(config, cl, propertyName, readMethod, value);
        if (type == null) {
            type = MetadataGenerator.getReturnTypeGeneric(readMethod, 0);
        }
        ArrayList<MetaObject> objects = new ArrayList<MetaObject>();
        for (Object o : value) {
            MetaObject meta = this.toMetaObject(config, cl, o, type);
            objects.add(meta);
        }
        return objects;
    }

    private Object getMetaObjectMap(T config, ClassLoader cl, String propertyName, Method readMethod, Map<String, ?> value) throws Exception {
        Class<?> type = this.getExplicitType(config, cl, propertyName, readMethod, value);
        if (type == null) {
            type = MetadataGenerator.getReturnTypeGeneric(readMethod, 1);
        }
        LinkedHashMap<String, MetaObject> objects = new LinkedHashMap<String, MetaObject>();
        for (String key : value.keySet()) {
            Object entryValue = value.get(key);
            MetaObject meta = this.toMetaObject(config, cl, entryValue, type);
            objects.put(key, meta);
        }
        return objects;
    }

    protected MetaObject toMetaObject(T config, ClassLoader cl, Object value, Class<?> type) throws Exception {
        if (!ClassUtils.isAssignable(value.getClass(), type)) {
            value = ConfigUtil.instantiateConfig((Map)value, type, new Object[0]);
        }
        MetadataGenerator<Object> generator = this.findGenerator(value);
        MetaObject metadata = generator.getMetadata(value, cl, config);
        return metadata;
    }

    protected MetadataGenerator<T> findGenerator(Object obj) {
        MetadataGenerator result = new MetadataGenerator();
        try {
            ConfigType configType;
            if (obj != null && (configType = MetadataGenerator.findAnnotation(obj.getClass(), ConfigType.class)) != null && configType.metadataGenerator() != null) {
                result = configType.metadataGenerator().newInstance();
            }
        }
        catch (Exception e) {
            log.error("Failed to initialize Metadata generator", e);
        }
        result.setContext(this.context);
        return result;
    }

    protected Class<?> getExplicitType(T config, ClassLoader cl, String propertyName, Method readMethod, Object value) throws ClassNotFoundException {
        ConfigFieldEditorType editor = ConfigUtil.findAnnotation(readMethod, ConfigFieldEditorType.class);
        Class<?> type = null;
        if (editor != null && !StringUtils.isEmpty(editor.className())) {
            type = cl.loadClass(editor.className());
        }
        return type;
    }

    protected ConfigFieldEditorType.EditorType getEditorType(T config, ClassLoader cl, String propertyName, Method readMethod) {
        ConfigFieldEditorType editor = ConfigUtil.findAnnotation(readMethod, ConfigFieldEditorType.class);
        if (editor != null) {
            return editor.editor();
        }
        return this.guessEditorType(config, cl, propertyName, readMethod);
    }

    protected ConfigFieldEditorType.EditorType guessEditorType(T config, ClassLoader cl, String propertyName, Method readMethod) {
        Class<?> returnType = readMethod.getReturnType();
        if (ClassUtils.isAssignable(returnType, String.class)) {
            return ConfigFieldEditorType.EditorType.String;
        }
        if (returnType.isEnum()) {
            return ConfigFieldEditorType.EditorType.String;
        }
        if (ClassUtils.isAssignable(returnType, Number.class, true)) {
            return ConfigFieldEditorType.EditorType.Number;
        }
        if (ClassUtils.isAssignable(returnType, Boolean.class, true)) {
            return ConfigFieldEditorType.EditorType.Boolean;
        }
        if (ClassUtils.isAssignable(returnType, List.class)) {
            Class<?> genericClass = MetadataGenerator.getReturnTypeGeneric(readMethod, 0);
            if (genericClass != null && ClassUtils.isAssignable(genericClass, String.class)) {
                return ConfigFieldEditorType.EditorType.StringList;
            }
            if (genericClass != null && MetadataGenerator.findAnnotation(genericClass, ConfigType.class) != null) {
                return ConfigFieldEditorType.EditorType.ObjectList;
            }
        }
        if (ClassUtils.isAssignable(returnType, Map.class)) {
            Class<?> genericClassKey = MetadataGenerator.getReturnTypeGeneric(readMethod, 0);
            Class<?> genericClassValue = MetadataGenerator.getReturnTypeGeneric(readMethod, 1);
            if (genericClassKey != null && ClassUtils.isAssignable(genericClassKey, String.class)) {
                if (genericClassValue != null && ClassUtils.isAssignable(genericClassValue, String.class)) {
                    return ConfigFieldEditorType.EditorType.StringMap;
                }
                if (genericClassValue != null && MetadataGenerator.findAnnotation(genericClassValue, ConfigType.class) != null) {
                    return ConfigFieldEditorType.EditorType.ObjectMap;
                }
            }
        }
        if (ClassUtils.isAssignable(returnType, Object.class) && MetadataGenerator.findAnnotation(returnType, ConfigType.class) != null) {
            return ConfigFieldEditorType.EditorType.Object;
        }
        return ConfigFieldEditorType.EditorType.Generic;
    }

    protected ConfigGroup getTab(T config, ClassLoader cl, String propertyName, Method readMethod) {
        ConfigField configField = ConfigUtil.findAnnotation(readMethod, ConfigField.class);
        return configField.tab();
    }

    protected String getLabel(T config, ClassLoader cl, String propertyName, Method readMethod) {
        ConfigField configField = ConfigUtil.findAnnotation(readMethod, ConfigField.class);
        if (!StringUtils.isEmpty(configField.label())) {
            return configField.label();
        }
        return propertyName;
    }

    protected String getDescription(T config, ClassLoader cl, String propertyName, Method readMethod) {
        ConfigField configField = ConfigUtil.findAnnotation(readMethod, ConfigField.class);
        if (!StringUtils.isEmpty(configField.description())) {
            return configField.description();
        }
        return null;
    }

    protected VariableSetName isVariables(T config, ClassLoader cl, String propertyName, Method readMethod) {
        ConfigFieldVariables variables = ConfigUtil.findAnnotation(readMethod, ConfigFieldVariables.class);
        if (variables != null) {
            return variables.value();
        }
        return null;
    }

    protected boolean isDiscriminator(T config, ClassLoader cl, String propertyName, Method readMethod) {
        ConfigFieldDiscriminator discriminator = ConfigUtil.findAnnotation(readMethod, ConfigFieldDiscriminator.class);
        return discriminator != null;
    }

    protected String[] getPresets(T config, ClassLoader cl, String propertyName, Method readMethod) {
        ConfigFieldPresets presets = ConfigUtil.findAnnotation(readMethod, ConfigFieldPresets.class);
        if (presets != null) {
            ArrayList<String> values = new ArrayList<String>(Arrays.asList(presets.value()));
            Class<? extends Enum> enumClass = presets.enumClass();
            Enum[] constants = enumClass.getEnumConstants();
            if (constants != null) {
                for (Enum c : constants) {
                    values.add(c.name());
                }
            }
            return values.toArray(new String[values.size()]);
        }
        return this.guessPresets(config, cl, propertyName, readMethod);
    }

    protected String[] guessPresets(T config, ClassLoader cl, String propertyName, Method readMethod) {
        ?[] constants;
        if (readMethod.getReturnType().isEnum() && (constants = readMethod.getReturnType().getEnumConstants()) != null) {
            String[] result = new String[constants.length];
            for (int i = 0; i < constants.length; ++i) {
                Enum enumConstant = (Enum)constants[i];
                result[i] = enumConstant.name();
            }
            return result;
        }
        return null;
    }

    public static <T extends Annotation> T findAnnotation(Class<?> type, Class<T> ann) {
        T annotation = type.getAnnotation(ann);
        if (annotation != null) {
            return annotation;
        }
        ArrayList superClasses = new ArrayList();
        superClasses.addAll(ClassUtils.getAllSuperclasses(type));
        superClasses.addAll(ClassUtils.getAllInterfaces(type));
        for (Class clazz : superClasses) {
            annotation = clazz.getAnnotation(ann);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    public static Class<?> getReturnTypeGeneric(Method m, int index) {
        Class<?> generic = MetadataGenerator.getGenericClass(m.getGenericReturnType(), index);
        if (generic == null) {
            Set<Method> overrideHierarchy = MethodUtils.getOverrideHierarchy(m, ClassUtils.Interfaces.INCLUDE);
            for (Method om : overrideHierarchy) {
                generic = MetadataGenerator.getGenericClass(om.getGenericReturnType(), index);
                if (generic == null) continue;
                return generic;
            }
        }
        return null;
    }

    public static Class<?> getGenericClass(Type genericType, int index) {
        Type[] generics;
        if (genericType instanceof ParameterizedType && (generics = ((ParameterizedType)genericType).getActualTypeArguments()) != null && generics[index] instanceof Class) {
            return (Class)generics[index];
        }
        return null;
    }

    public static Class<?> getConfigTypeFromConstructor(Class<?> moduleClass) {
        Class<?> configClass = null;
        for (Constructor<?> constructor : moduleClass.getConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != 1 || !Config.class.isAssignableFrom(parameterTypes[0])) continue;
            configClass = parameterTypes[0];
            break;
        }
        return configClass;
    }

    public ConfigContext getContext() {
        return this.context;
    }

    public void setContext(ConfigContext context) {
        this.context = context;
    }
}

