/*
 * Decompiled with CFR 0.152.
 */
package com.wutka.dtd;

import com.wutka.dtd.DTDAttribute;
import com.wutka.dtd.DTDOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class DTDAttlist
implements DTDOutput {
    public String name;
    public Vector attributes;

    public DTDAttlist() {
        this.attributes = new Vector();
    }

    public DTDAttlist(String string) {
        this.name = string;
        this.attributes = new Vector();
    }

    public void write(PrintWriter printWriter) throws IOException {
        printWriter.print("<!ATTLIST ");
        printWriter.println(this.name);
        Iterator iterator = ((AbstractList)this.attributes).iterator();
        while (iterator.hasNext()) {
            printWriter.print("           ");
            DTDAttribute dTDAttribute = (DTDAttribute)iterator.next();
            dTDAttribute.write(printWriter);
            if (iterator.hasNext()) {
                printWriter.println();
                continue;
            }
            printWriter.println(">");
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DTDAttlist)) {
            return false;
        }
        DTDAttlist dTDAttlist = (DTDAttlist)object;
        if (this.name == null && dTDAttlist.name != null) {
            return false;
        }
        if (this.name != null && !this.name.equals(dTDAttlist.name)) {
            return false;
        }
        return this.attributes.equals(dTDAttlist.attributes);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public DTDAttribute[] getAttribute() {
        Object[] objectArray = new DTDAttribute[this.attributes.size()];
        this.attributes.copyInto(objectArray);
        return objectArray;
    }

    public void setAttribute(DTDAttribute[] dTDAttributeArray) {
        this.attributes = new Vector(dTDAttributeArray.length);
        int n = 0;
        while (n < dTDAttributeArray.length) {
            this.attributes.addElement(dTDAttributeArray[n]);
            ++n;
        }
    }

    public DTDAttribute getAttribute(int n) {
        return (DTDAttribute)this.attributes.elementAt(n);
    }

    public void setAttribute(DTDAttribute dTDAttribute, int n) {
        this.attributes.setElementAt(dTDAttribute, n);
    }
}

