/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.pcx;

import com.sun.jimi.core.decoder.pcx.PCXHeader;
import com.sun.jimi.core.util.LEDataInputStream;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class PCXColorMap {
    private byte[] f1;
    private byte[] f2;
    private byte[] f3;
    private ColorModel f4;

    public ColorModel getColorModel() {
        return this.f4;
    }

    public PCXColorMap(LEDataInputStream lEDataInputStream, int n, byte by) {
        if (by == PCXHeader.V3_0p) {
            try {
                lEDataInputStream.mark(n);
                lEDataInputStream.skip(n - 16 - 769);
                if (lEDataInputStream.readByte() == 12) {
                    this.f1 = new byte[256];
                    this.f2 = new byte[256];
                    this.f3 = new byte[256];
                    int n2 = 0;
                    while (n2 < 256) {
                        this.f1[n2] = lEDataInputStream.readByte();
                        this.f2[n2] = lEDataInputStream.readByte();
                        this.f3[n2] = lEDataInputStream.readByte();
                        ++n2;
                    }
                    this.f4 = new IndexColorModel(8, 256, this.f1, this.f2, this.f3);
                    lEDataInputStream.reset();
                    lEDataInputStream.skip(48L);
                    return;
                }
                lEDataInputStream.reset();
                this.f1 = new byte[16];
                this.f2 = new byte[16];
                this.f3 = new byte[16];
                int n3 = 0;
                while (n3 < 16) {
                    this.f1[n3] = lEDataInputStream.readByte();
                    this.f2[n3] = lEDataInputStream.readByte();
                    this.f3[n3] = lEDataInputStream.readByte();
                    ++n3;
                }
                this.f4 = new IndexColorModel(4, 16, this.f1, this.f2, this.f3);
                return;
            }
            catch (Exception exception) {}
        }
    }
}

