/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.MemoryJimiImageFactory;
import com.sun.jimi.core.VMMControl;
import com.sun.jimi.core.raster.BitRasterImage;
import com.sun.jimi.core.raster.ByteRasterImage;
import com.sun.jimi.core.raster.ChanneledIntRasterImage;
import com.sun.jimi.core.raster.IntRasterImage;
import com.sun.jimi.core.raster.VMemByteRasterImage;
import com.sun.jimi.core.raster.VMemChanneledIntRasterImage;
import com.sun.jimi.core.raster.VMemIntRasterImage;
import com.sun.jimi.util.FileRandomAccessStorage;
import com.sun.jimi.util.RandomAccessStorage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;

public class VMemJimiImageFactory
implements JimiImageFactory {
    protected static long id;
    protected JimiImageFactory memoryFactory = new MemoryJimiImageFactory();

    public IntRasterImage createIntRasterImage(int n, int n2, ColorModel colorModel) {
        try {
            if (n * n2 << 2 < VMMControl.threshold) {
                return this.memoryFactory.createIntRasterImage(n, n2, colorModel);
            }
            return new VMemIntRasterImage(VMemJimiImageFactory.createNextStorage(VMMControl.getDirectory()), n, n2, colorModel);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ByteRasterImage createByteRasterImage(int n, int n2, ColorModel colorModel) {
        try {
            if (n * n2 < VMMControl.threshold) {
                return this.memoryFactory.createByteRasterImage(n, n2, colorModel);
            }
            return new VMemByteRasterImage(VMemJimiImageFactory.createNextStorage(VMMControl.getDirectory()), n, n2, colorModel);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public BitRasterImage createBitRasterImage(int n, int n2, ColorModel colorModel) {
        try {
            if (n * n2 >> 3 < VMMControl.threshold) {
                return this.memoryFactory.createBitRasterImage(n, n2, colorModel);
            }
            int n3 = colorModel.getRGB(0);
            int n4 = colorModel.getRGB(1);
            byte[] byArray = new byte[]{(byte)(n3 >> 24 & 0xFF), (byte)(n4 >> 24 & 0xFF)};
            byte[] byArray2 = new byte[]{(byte)(n3 >> 16 & 0xFF), (byte)(n4 >> 16 & 0xFF)};
            byte[] byArray3 = new byte[]{(byte)(n3 >> 8 & 0xFF), (byte)(n4 >> 8 & 0xFF)};
            byte[] byArray4 = new byte[]{(byte)(n3 & 0xFF), (byte)(n4 & 0xFF)};
            colorModel = new IndexColorModel(8, 2, byArray2, byArray3, byArray4, byArray);
            return (BitRasterImage)this.createByteRasterImage(n, n2, colorModel);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ChanneledIntRasterImage createChanneledIntRasterImage(int n, int n2, ColorModel colorModel) {
        try {
            if (n * n2 << 2 < VMMControl.threshold) {
                return this.memoryFactory.createChanneledIntRasterImage(n, n2, colorModel);
            }
            return new VMemChanneledIntRasterImage(VMemJimiImageFactory.createNextStorage(VMMControl.getDirectory()), n, n2, colorModel);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static synchronized RandomAccessStorage createNextStorage(File file) throws IOException {
        String string;
        File file2;
        while ((file2 = new File(string = file + "/" + "jimidat." + ++id)).exists() && !file2.delete()) {
        }
        return new FileRandomAccessStorage(file2);
    }
}

