/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.parsers.DocumentBuilderFactory;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineXmlCommand;
import org.tigris.subversion.svnclientadapter.commandline.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class CmdLineRemoteDirEntry
extends CmdLineXmlCommand
implements ISVNDirEntry {
    private String path;
    private SVNRevision.Number revision;
    private SVNNodeKind nodeKind;
    private String lastCommitAuthor;
    private Date lastChangedDate;
    private long size;

    protected CmdLineRemoteDirEntry(String path, SVNRevision.Number revision, long size, String author, Date date, SVNNodeKind kind) {
        this.lastCommitAuthor = author;
        this.lastChangedDate = date;
        this.nodeKind = kind;
        this.path = path;
        this.revision = revision;
        this.size = size;
    }

    public static CmdLineRemoteDirEntry[] createDirEntries(byte[] cmdLineResults) throws SVNClientException {
        ArrayList<CmdLineRemoteDirEntry> logMessages = new ArrayList<CmdLineRemoteDirEntry>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            InputSource source = new InputSource(new ByteArrayInputStream(cmdLineResults));
            Document doc = factory.newDocumentBuilder().parse(source);
            NodeList nodes = doc.getElementsByTagName("entry");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node logEntry = nodes.item(i);
                String kindName = logEntry.getAttributes().getNamedItem("kind").getNodeValue();
                Element nameNode = CmdLineRemoteDirEntry.getFirstNamedElement(logEntry, "name");
                if (nameNode == null) {
                    throw new Exception("'name' tag expected under 'entry'");
                }
                String name = nameNode.getFirstChild().getNodeValue();
                long size = 0L;
                Element sizeNode = null;
                if ("file".equals(kindName)) {
                    sizeNode = CmdLineRemoteDirEntry.getNextNamedElement(nameNode, "size");
                    if (sizeNode == null) {
                        throw new Exception("'size' tag expected under 'entry'");
                    }
                    size = Long.parseLong(sizeNode.getFirstChild().getNodeValue());
                } else {
                    sizeNode = nameNode;
                }
                Element commitNode = CmdLineRemoteDirEntry.getNextNamedElement(sizeNode, "commit");
                if (commitNode == null) {
                    throw new Exception("'commit' tag expected under 'entry'");
                }
                Node revisionAttribute = commitNode.getAttributes().getNamedItem("revision");
                SVNRevision.Number rev = Helper.toRevNum(revisionAttribute.getNodeValue());
                Element authorNode = CmdLineRemoteDirEntry.getFirstNamedElement(commitNode, "author");
                String author = null;
                if (authorNode != null) {
                    author = authorNode.getFirstChild().getNodeValue();
                }
                Element dateNode = CmdLineRemoteDirEntry.getNextNamedElement(authorNode, "date");
                Date date = null;
                if (dateNode != null) {
                    date = Helper.convertXMLDate(dateNode.getFirstChild().getNodeValue());
                }
                SVNNodeKind kind = SVNNodeKind.UNKNOWN;
                if ("file".equals(kindName)) {
                    kind = SVNNodeKind.FILE;
                } else if ("dir".equals(kindName)) {
                    kind = SVNNodeKind.DIR;
                }
                CmdLineRemoteDirEntry entry = new CmdLineRemoteDirEntry(name, rev, size, author, date, kind);
                logMessages.add(entry);
            }
        }
        catch (Exception e) {
            throw new SVNClientException(e);
        }
        return logMessages.toArray(new CmdLineRemoteDirEntry[logMessages.size()]);
    }

    public boolean getHasProps() {
        return false;
    }

    public SVNNodeKind getNodeKind() {
        return this.nodeKind;
    }

    public SVNRevision.Number getLastChangedRevision() {
        return this.revision;
    }

    public Date getLastChangedDate() {
        return this.lastChangedDate;
    }

    public String getLastCommitAuthor() {
        return this.lastCommitAuthor;
    }

    public String getPath() {
        return this.path;
    }

    public long getSize() {
        return this.size;
    }
}

