/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2.units;

import company.evo.jmorphy2.ParsedWord;
import company.evo.jmorphy2.Tag;
import company.evo.jmorphy2.units.AnalyzerUnit;
import company.evo.jmorphy2.units.PrefixedUnit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class UnknownPrefixUnit
extends PrefixedUnit {
    private final int maxPrefixLength;
    private final int minReminder;

    private UnknownPrefixUnit(Tag.Storage tagStorage, AnalyzerUnit unit, int maxPrefixLength, int minReminder, boolean terminate, float score) {
        super(tagStorage, unit, terminate, score);
        this.maxPrefixLength = maxPrefixLength;
        this.minReminder = minReminder;
    }

    @Override
    public List<ParsedWord> parse(String word, String wordLower) throws IOException {
        ArrayList<ParsedWord> parseds = new ArrayList<ParsedWord>();
        int wordLen = word.length();
        for (int i = 1; i <= this.maxPrefixLength && wordLen - i >= this.minReminder; ++i) {
            String prefix = wordLower.substring(0, i);
            parseds.addAll(this.parseWithPrefix(word, wordLower, prefix));
        }
        return parseds;
    }

    public static class Builder
    extends AnalyzerUnit.Builder {
        private static final int DEFAULT_MAX_PREFIX_LENGTH = 5;
        private static final int DEFAULT_MIN_REMINDER = 3;
        private AnalyzerUnit.Builder unit;
        private int minReminder = 3;
        private int maxPrefixLength = 5;

        public Builder(AnalyzerUnit.Builder unit, boolean terminate, float score) {
            super(terminate, score);
            this.unit = unit;
        }

        public Builder maxPrefixLength(int maxPrefixLength) {
            this.maxPrefixLength = maxPrefixLength;
            this.cachedUnit = null;
            return this;
        }

        public Builder minReminder(int minReminder) {
            this.minReminder = minReminder;
            this.cachedUnit = null;
            return this;
        }

        @Override
        protected AnalyzerUnit newAnalyzerUnit(Tag.Storage tagStorage) throws IOException {
            return new UnknownPrefixUnit(tagStorage, this.unit.build(tagStorage), this.maxPrefixLength, this.minReminder, this.terminate, this.score);
        }
    }
}

