/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2.units;

import com.google.common.collect.Lists;
import company.evo.jmorphy2.Tag;
import company.evo.jmorphy2.units.AnalyzerUnit;
import company.evo.jmorphy2.units.RegexUnit;

public class RomanUnit
extends RegexUnit {
    private static final String ROMAN_REGEX = "M{0,4}(CM|CD|D?C{0,3})(XC|XL|L?X{0,3})(IX|IV|V?I{0,3})";

    private RomanUnit(Tag.Storage tagStorage, boolean terminate, float score) {
        super(tagStorage, ROMAN_REGEX, "ROMN", terminate, score);
    }

    public static class Builder
    extends AnalyzerUnit.Builder {
        public Builder(boolean terminate, float score) {
            super(terminate, score);
        }

        @Override
        protected AnalyzerUnit newAnalyzerUnit(Tag.Storage tagStorage) {
            tagStorage.newGrammeme(Lists.newArrayList((Object[])new String[]{"ROMN", "", "\u0420\u0418\u041c", "\u0440\u0438\u043c\u0441\u043a\u0438\u0435 \u0446\u0438\u0444\u0440\u044b"}));
            tagStorage.newTag("ROMN");
            return new RomanUnit(tagStorage, this.terminate, this.score);
        }
    }
}

