/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2.units;

import company.evo.jmorphy2.ParsedWord;
import company.evo.jmorphy2.Tag;
import company.evo.jmorphy2.units.AnalyzerUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class RegexUnit
extends AnalyzerUnit {
    protected final Pattern pattern;
    protected final String tagString;

    public RegexUnit(Tag.Storage tagStorage, String regex, String tagString, boolean terminate, float score) {
        super(tagStorage, terminate, score);
        this.pattern = Pattern.compile(regex);
        this.tagString = tagString;
    }

    @Override
    public List<ParsedWord> parse(String word, String wordLower) {
        if (this.pattern.matcher(word).matches()) {
            ArrayList<ParsedWord> parseds = new ArrayList<ParsedWord>();
            parseds.add(new AnalyzerUnit.AnalyzerParsedWord(word, this.tagStorage.getTag(this.tagString), word, word, this.score));
            return parseds;
        }
        return null;
    }
}

