/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2.units;

import company.evo.jmorphy2.Dictionary;
import company.evo.jmorphy2.ParsedWord;
import company.evo.jmorphy2.SuffixesDAWG;
import company.evo.jmorphy2.Tag;
import company.evo.jmorphy2.units.AnalyzerUnit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class KnownSuffixUnit
extends AnalyzerUnit {
    private final Dictionary dict;
    private Map<Character, String> charSubstitutes;
    private final int minWordLength;
    private final int maxSuffixLength;

    private KnownSuffixUnit(Tag.Storage tagStorage, Dictionary dict, Map<Character, String> charSubstitutes, int minWordLength, int maxSuffixLength, boolean terminate, float score) {
        super(tagStorage, terminate, score);
        this.dict = dict;
        this.charSubstitutes = charSubstitutes;
        this.minWordLength = minWordLength;
        this.maxSuffixLength = maxSuffixLength;
    }

    @Override
    public List<ParsedWord> parse(String word, String wordLower) throws IOException {
        int wordLen = wordLower.length();
        if (wordLen < this.minWordLength) {
            return null;
        }
        ArrayList<ParsedWordWithPrefixId> parseds = new ArrayList<ParsedWordWithPrefixId>();
        String[] paradigmPrefixes = this.dict.getParadigmPrefixes();
        int maxSuffixLength = Math.min(this.maxSuffixLength, wordLen);
        int[] totalCounts = new int[paradigmPrefixes.length];
        block0: for (int prefixId = 0; prefixId < paradigmPrefixes.length; ++prefixId) {
            String prefix = paradigmPrefixes[prefixId];
            if (!wordLower.startsWith(prefix)) continue;
            for (int i = maxSuffixLength; i >= 1; --i) {
                String wordStart = wordLower.substring(0, wordLen - i);
                String wordEnd = wordLower.substring(wordLen - i);
                SuffixesDAWG predictionSuffixes = this.dict.getPredictionSuffixes(prefixId);
                for (SuffixesDAWG.SuffixForm sf : predictionSuffixes.similarSuffixes(wordEnd, this.charSubstitutes)) {
                    int n = prefixId;
                    totalCounts[n] = totalCounts[n] + sf.count;
                    Tag tag = this.dict.buildTag(sf.paradigmId, sf.idx);
                    if (!tag.isProductive()) continue;
                    String normalForm = this.dict.buildNormalForm(sf.paradigmId, sf.idx, wordStart + sf.word);
                    float score = this.score * (float)sf.count;
                    parseds.add(new ParsedWordWithPrefixId(new KnownSuffixParsedWord(wordStart + sf.word, tag, normalForm, sf.word, sf, score), prefixId));
                }
                if (parseds.size() > 0) continue block0;
            }
        }
        ArrayList<ParsedWord> normParseds = new ArrayList<ParsedWord>();
        for (ParsedWordWithPrefixId p : parseds) {
            normParseds.add(p.parsedWord.rescore(p.parsedWord.score / (float)totalCounts[p.prefixId]));
        }
        return normParseds;
    }

    class ParsedWordWithPrefixId {
        public final ParsedWord parsedWord;
        public final int prefixId;

        public ParsedWordWithPrefixId(ParsedWord parsedWord, int prefixId) {
            this.parsedWord = parsedWord;
            this.prefixId = prefixId;
        }
    }

    class KnownSuffixParsedWord
    extends AnalyzerUnit.AnalyzerParsedWord {
        private final SuffixesDAWG.SuffixForm suffixForm;

        public KnownSuffixParsedWord(String word, Tag tag, String normalForm, String foundWord, SuffixesDAWG.SuffixForm suffixForm, float score) {
            super(word, tag, normalForm, foundWord, score);
            this.suffixForm = suffixForm;
        }

        @Override
        public ParsedWord rescore(float newScore) {
            return new KnownSuffixParsedWord(this.word, this.tag, this.normalForm, this.foundWord, this.suffixForm, newScore);
        }

        @Override
        public List<ParsedWord> getLexeme() {
            ArrayList<ParsedWord> lexeme = new ArrayList<ParsedWord>();
            Dictionary.Paradigm paradigm = KnownSuffixUnit.this.dict.getParadigm(this.suffixForm.paradigmId);
            short s = paradigm.size();
            String wordPrefix = this.word.substring(0, this.word.length() - this.suffixForm.word.length());
            String stem = wordPrefix + KnownSuffixUnit.this.dict.buildStem(this.suffixForm.paradigmId, this.suffixForm.idx, this.suffixForm.word);
            String normalForm = wordPrefix + KnownSuffixUnit.this.dict.buildNormalForm(this.suffixForm.paradigmId, this.suffixForm.idx, this.suffixForm.word);
            for (short idx = 0; idx < s; idx = (short)(idx + 1)) {
                String prefix = KnownSuffixUnit.this.dict.getParadigmPrefixes()[paradigm.getStemPrefixId(idx)];
                String suffix = KnownSuffixUnit.this.dict.getSuffix(this.suffixForm.paradigmId, idx);
                String word = prefix + stem + suffix;
                Tag tag = KnownSuffixUnit.this.dict.buildTag(this.suffixForm.paradigmId, idx);
                SuffixesDAWG.SuffixForm sf = new SuffixesDAWG.SuffixForm(this.suffixForm.word, 0, this.suffixForm.paradigmId, idx);
                lexeme.add(new KnownSuffixParsedWord(word, tag, normalForm, sf.word, sf, this.score));
            }
            return lexeme;
        }
    }

    public static class Builder
    extends AnalyzerUnit.Builder {
        private static final int DEFAULT_MAX_SUFFIX_LENGTH = 5;
        private static final int DEFAULT_MIN_WORD_LENGTH = 4;
        private Dictionary.Builder dictBuilder;
        private Map<Character, String> charSubstitutes;
        private int minWordLength = 4;
        private int maxSuffixLength = 5;

        public Builder(Dictionary.Builder dictBuilder, boolean terminate, float score) {
            super(terminate, score);
            this.dictBuilder = dictBuilder;
        }

        public Builder minWordLength(int minWordLength) {
            this.minWordLength = minWordLength;
            this.cachedUnit = null;
            return this;
        }

        public Builder maxSuffixLength(int maxSuffixLength) {
            this.maxSuffixLength = maxSuffixLength;
            this.cachedUnit = null;
            return this;
        }

        public Builder charSubstitutes(Map<Character, String> charSubstitutes) {
            this.charSubstitutes = charSubstitutes;
            this.cachedUnit = null;
            return this;
        }

        @Override
        protected AnalyzerUnit newAnalyzerUnit(Tag.Storage tagStorage) throws IOException {
            return new KnownSuffixUnit(tagStorage, this.dictBuilder.build(tagStorage), this.charSubstitutes, this.minWordLength, this.maxSuffixLength, this.terminate, this.score);
        }
    }
}

