/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2.units;

import company.evo.jmorphy2.ParsedWord;
import company.evo.jmorphy2.Tag;
import company.evo.jmorphy2.units.AnalyzerUnit;
import company.evo.jmorphy2.units.PrefixedUnit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class KnownPrefixUnit
extends PrefixedUnit {
    private final int minReminder;
    private final Set<String> prefixes;

    private KnownPrefixUnit(Tag.Storage tagStorage, AnalyzerUnit unit, Set<String> prefixes, int minReminder, boolean terminate, float score) {
        super(tagStorage, unit, terminate, score);
        this.minReminder = minReminder;
        this.prefixes = prefixes;
    }

    @Override
    public List<ParsedWord> parse(String word, String wordLower) throws IOException {
        ArrayList<ParsedWord> parseds = new ArrayList<ParsedWord>();
        int wordLen = word.length();
        int i = 1;
        while (wordLen - i >= this.minReminder) {
            String prefix = wordLower.substring(0, i);
            if (this.prefixes.contains(prefix)) {
                parseds.addAll(this.parseWithPrefix(word, wordLower, prefix));
            }
            ++i;
        }
        return parseds;
    }

    public static class Builder
    extends AnalyzerUnit.Builder {
        private static final int DEFAULT_MIN_REMINDER = 3;
        private AnalyzerUnit.Builder unit;
        private Set<String> prefixes;
        private int minReminder = 3;

        public Builder(AnalyzerUnit.Builder unit, Set<String> prefixes, boolean terminate, float score) {
            super(terminate, score);
            this.unit = unit;
            this.prefixes = prefixes;
        }

        public Builder minReminder(int minReminder) {
            this.minReminder = minReminder;
            this.cachedUnit = null;
            return this;
        }

        @Override
        protected AnalyzerUnit newAnalyzerUnit(Tag.Storage tagStorage) throws IOException {
            return new KnownPrefixUnit(tagStorage, this.unit.build(tagStorage), this.prefixes, this.minReminder, this.terminate, this.score);
        }
    }
}

