/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2;

import company.evo.jmorphy2.MorphAnalyzer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Resources {
    public static Map<Character, String> getCharSubstitutes(MorphAnalyzer.Lang lang) throws IOException {
        HashMap<Character, String> substitutes = new HashMap<Character, String>();
        for (String line : Resources.readLines(lang, "char_substitutes.txt")) {
            String key;
            String[] parts = line.split("=>", 2);
            if (parts.length != 2 || (key = parts[0].trim()).length() == 0) continue;
            String value = parts[1].trim();
            substitutes.put(Character.valueOf(key.charAt(0)), value);
        }
        return substitutes;
    }

    public static Set<String> getKnownPrefixes(MorphAnalyzer.Lang lang) throws IOException {
        HashSet<String> prefixes = new HashSet<String>();
        for (String line : Resources.readLines(lang, "known_prefixes.txt")) {
            prefixes.add(line.toLowerCase());
        }
        return prefixes;
    }

    private static List<String> readLines(MorphAnalyzer.Lang lang, String filename) throws IOException {
        String path = String.format("/lang/%s/%s", lang.name().toLowerCase(), filename);
        BufferedReader reader = new BufferedReader(new InputStreamReader(Resources.class.getResourceAsStream(path), StandardCharsets.UTF_8));
        ArrayList<String> lines = new ArrayList<String>();
        String line = null;
        while ((line = reader.readLine()) != null) {
            String processedLine = Resources.processLine(Resources.parseString(line));
            if (processedLine.equals("")) continue;
            lines.add(processedLine);
        }
        return lines;
    }

    private static String processLine(String line) {
        String[] parts = line.split("#", 2);
        if (parts.length == 0) {
            return "";
        }
        String processedLine = parts[0].trim();
        return processedLine;
    }

    private static String parseString(String s) {
        int readPos = 0;
        int len = s.length();
        boolean writePos = false;
        String out = "";
        while (readPos < len) {
            int c;
            if ((c = s.charAt(readPos++)) == 92) {
                if (readPos >= len) {
                    throw new RuntimeException("Invalid escaped char in [" + s + "]");
                }
                c = s.charAt(readPos++);
                switch (c) {
                    case 92: {
                        c = 92;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 98: {
                        c = 8;
                        break;
                    }
                    case 102: {
                        c = 12;
                        break;
                    }
                    case 117: {
                        if (readPos + 3 >= len) {
                            throw new RuntimeException("Invalid escaped char in [" + s + "]");
                        }
                        c = (char)Integer.parseInt(s.substring(readPos, readPos + 4), 16);
                        readPos += 4;
                    }
                }
            }
            out = out + (char)c;
        }
        return out;
    }
}

