/*
 * Decompiled with CFR 0.152.
 */
package company.evo.dawg;

import company.evo.dawg.DAWG;
import company.evo.dawg.Dict;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class PayloadsDAWG
extends DAWG {
    private static final byte PAYLOAD_SEPARATOR = 1;
    private final Guide guide;

    public PayloadsDAWG(InputStream stream) throws IOException {
        super(stream);
        this.guide = new Guide(this.input);
    }

    protected List<Payload> valueForIndex(int index, String key) throws IOException {
        ArrayList<Payload> values = new ArrayList<Payload>();
        Completer completer = new Completer(this.dict, this.guide);
        boolean i = false;
        completer.start(index);
        while (completer.next()) {
            values.add(new Payload(key, this.decodeValue(completer.getKey())));
        }
        return values;
    }

    protected byte[] decodeValue(byte[] value) {
        new Base64();
        return Base64.decodeBase64((byte[])value);
    }

    public List<Payload> similarItems(String key) throws IOException {
        return this.similarItems(key, null);
    }

    public List<Payload> similarItems(String key, Map<Character, String> replaceChars) throws IOException {
        return this.similarItems(key, replaceChars, "", 0);
    }

    private List<Payload> similarItems(String key, Map<Character, String> replaceChars, String prefix, int index) throws IOException {
        int prefixLength;
        ArrayList<Payload> items = new ArrayList<Payload>();
        int keyLength = key.length();
        for (int i = prefixLength = prefix.length(); i < keyLength; ++i) {
            String replaces;
            char c = key.charAt(i);
            if (replaceChars != null && (replaces = replaceChars.get(Character.valueOf(c))) != null) {
                int replacesLength = replaces.length();
                for (int j = 0; j < replacesLength; ++j) {
                    String r = replaces.substring(j, j + 1);
                    int nextIndex = this.dict.followBytes(r.getBytes("UTF-8"), index);
                    if (nextIndex == -1) continue;
                    String nextPrefix = prefix + key.substring(prefixLength, i) + r;
                    items.addAll(this.similarItems(key, replaceChars, nextPrefix, nextIndex));
                }
            }
            if ((index = this.dict.followBytes(Character.toString(c).getBytes("UTF-8"), index)) != -1) continue;
            return items;
        }
        if (index == -1) {
            return items;
        }
        if ((index = this.dict.followByte((byte)1, index)) == -1) {
            return items;
        }
        return this.valueForIndex(index, prefix + key.substring(prefixLength));
    }

    public static class Payload {
        public final String key;
        public final byte[] value;

        public Payload(String key, byte[] value) {
            this.key = key;
            this.value = value;
        }
    }

    private class Completer {
        private Dict dict;
        private Guide guide;
        private byte[] key;
        private int keyLength;
        private ArrayList<Integer> indexStack;
        private int lastIndex;
        private static final int INITIAL_KEY_LENGTH = 9;

        public Completer(Dict dict, Guide guide) {
            this.dict = dict;
            this.guide = guide;
        }

        public void start(int index) {
            this.key = new byte[9];
            this.keyLength = 0;
            this.indexStack = new ArrayList();
            this.indexStack.add(index);
            this.lastIndex = 0;
        }

        public boolean next() {
            int index = this.indexStack.get(this.indexStack.size() - 1);
            if (this.lastIndex != 0) {
                byte childLabel = this.guide.child(index);
                if (childLabel != 0) {
                    if ((index = this.follow(childLabel, index)) == -1) {
                        return false;
                    }
                } else {
                    byte siblingLabel;
                    do {
                        siblingLabel = this.guide.sibling(index);
                        if (this.keyLength > 0) {
                            --this.keyLength;
                        }
                        this.indexStack.remove(this.indexStack.size() - 1);
                        if (this.indexStack.isEmpty()) {
                            return false;
                        }
                        index = this.indexStack.get(this.indexStack.size() - 1);
                    } while (siblingLabel == 0);
                    if ((index = this.follow(siblingLabel, index)) == -1) {
                        return false;
                    }
                }
            }
            return this.findTerminal(index);
        }

        public byte[] getKey() {
            byte[] newKey = new byte[this.keyLength];
            System.arraycopy(this.key, 0, newKey, 0, this.keyLength);
            return newKey;
        }

        private int follow(byte label, int index) {
            int nextIndex = this.dict.followByte(label, index);
            if (nextIndex == -1) {
                return -1;
            }
            this.addLabel(label);
            this.indexStack.add(nextIndex);
            return nextIndex;
        }

        private boolean findTerminal(int index) {
            while (!this.dict.hasValue(index)) {
                byte label = this.guide.child(index);
                if ((index = this.dict.followByte(label, index)) == -1) {
                    return false;
                }
                this.addLabel(label);
                this.indexStack.add(index);
            }
            this.lastIndex = index;
            return true;
        }

        private void addLabel(byte label) {
            if (this.keyLength == this.key.length) {
                byte[] newKey = new byte[this.key.length * 2];
                System.arraycopy(this.key, 0, newKey, 0, this.key.length);
                this.key = newKey;
            }
            this.key[this.keyLength] = label;
            ++this.keyLength;
        }
    }

    private class Guide {
        private byte[] units;

        public Guide(DataInput input) throws IOException {
            int baseSize = input.readInt();
            int size = baseSize * 2;
            this.units = new byte[size];
            for (int i = 0; i < size; ++i) {
                this.units[i] = input.readByte();
            }
        }

        public byte child(int index) {
            return this.units[index * 2];
        }

        public byte sibling(int index) {
            return this.units[index * 2 + 1];
        }

        public int size() {
            return this.units.length;
        }
    }
}

