/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling.suggest;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.suggest.FileDictionary;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.spelling.suggest.DictionaryFactory;

public class FileDictionaryFactory
extends DictionaryFactory {
    public static final String FIELD_DELIMITER = "fieldDelimiter";

    @Override
    public Dictionary create(SolrCore core, SolrIndexSearcher searcher) {
        if (this.params == null) {
            throw new IllegalStateException("Value of params not set");
        }
        String sourceLocation = (String)this.params.get("sourceLocation");
        if (sourceLocation == null) {
            throw new IllegalArgumentException("sourceLocation parameter is mandatory for using FileDictionary");
        }
        String fieldDelimiter = this.params.get(FIELD_DELIMITER) != null ? (String)this.params.get(FIELD_DELIMITER) : "\t";
        try {
            return new FileDictionary((Reader)new InputStreamReader(core.getResourceLoader().openResource(sourceLocation), IOUtils.CHARSET_UTF_8), fieldDelimiter);
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }
}

