/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.ExchangeRateProvider;
import org.noggit.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenExchangeRatesOrgProvider
implements ExchangeRateProvider {
    public static Logger log = LoggerFactory.getLogger(OpenExchangeRatesOrgProvider.class);
    protected static final String PARAM_RATES_FILE_LOCATION = "ratesFileLocation";
    protected static final String PARAM_REFRESH_INTERVAL = "refreshInterval";
    protected static final String DEFAULT_REFRESH_INTERVAL = "1440";
    protected String ratesFileLocation;
    protected int refreshIntervalSeconds;
    protected ResourceLoader resourceLoader;
    protected OpenExchangeRates rates;

    @Override
    public double getExchangeRate(String sourceCurrencyCode, String targetCurrencyCode) {
        if (this.rates == null) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Rates not initialized.");
        }
        if (sourceCurrencyCode == null || targetCurrencyCode == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot get exchange rate; currency was null.");
        }
        if ((this.rates.getTimestamp() + (long)this.refreshIntervalSeconds) * 1000L < System.currentTimeMillis()) {
            log.debug("Refresh interval has expired. Refreshing exchange rates.");
            this.reload();
        }
        Double source = this.rates.getRates().get(sourceCurrencyCode);
        Double target = this.rates.getRates().get(targetCurrencyCode);
        if (source == null || target == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No available conversion rate from " + sourceCurrencyCode + " to " + targetCurrencyCode + ". " + "Available rates are " + this.listAvailableCurrencies());
        }
        return target / source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenExchangeRatesOrgProvider that = (OpenExchangeRatesOrgProvider)o;
        return !(this.rates == null ? that.rates != null : !this.rates.equals(that.rates));
    }

    public int hashCode() {
        return this.rates != null ? this.rates.hashCode() : 0;
    }

    public String toString() {
        return "[" + this.getClass().getName() + " : " + this.rates.getRates().size() + " rates.]";
    }

    @Override
    public Set<String> listAvailableCurrencies() {
        if (this.rates == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Rates not initialized");
        }
        return this.rates.getRates().keySet();
    }

    @Override
    public boolean reload() throws SolrException {
        InputStream ratesJsonStream = null;
        try {
            log.info("Reloading exchange rates from " + this.ratesFileLocation);
            try {
                ratesJsonStream = new URL(this.ratesFileLocation).openStream();
            }
            catch (Exception e) {
                ratesJsonStream = this.resourceLoader.openResource(this.ratesFileLocation);
            }
            this.rates = new OpenExchangeRates(ratesJsonStream);
            boolean e = true;
            return e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reloading exchange rates", (Throwable)e);
        }
        finally {
            if (ratesJsonStream != null) {
                try {
                    ratesJsonStream.close();
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error closing stream", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void init(Map<String, String> params) throws SolrException {
        try {
            this.ratesFileLocation = params.get(PARAM_RATES_FILE_LOCATION);
            if (null == this.ratesFileLocation) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Init param must be specified: ratesFileLocation");
            }
            int refreshInterval = Integer.parseInt(this.getParam(params.get(PARAM_REFRESH_INTERVAL), DEFAULT_REFRESH_INTERVAL));
            if (refreshInterval < 60) {
                refreshInterval = 60;
                log.warn("Specified refreshInterval was too small. Setting to 60 minutes which is the update rate of openexchangerates.org");
            }
            log.info("Initialized with rates=" + this.ratesFileLocation + ", refreshInterval=" + refreshInterval + ".");
            this.refreshIntervalSeconds = refreshInterval * 60;
        }
        catch (SolrException e1) {
            throw e1;
        }
        catch (Exception e2) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error initializing: " + e2.getMessage(), (Throwable)e2);
        }
        finally {
            params.remove(PARAM_RATES_FILE_LOCATION);
            params.remove(PARAM_REFRESH_INTERVAL);
        }
    }

    @Override
    public void inform(ResourceLoader loader) throws SolrException {
        this.resourceLoader = loader;
        this.reload();
    }

    private String getParam(String param, String defaultParam) {
        return param == null ? defaultParam : param;
    }

    static class OpenExchangeRates {
        private Map<String, Double> rates;
        private String baseCurrency;
        private long timestamp;
        private String disclaimer;
        private String license;
        private JSONParser parser;

        public OpenExchangeRates(InputStream ratesStream) throws IOException {
            int ev;
            this.parser = new JSONParser((Reader)new InputStreamReader(ratesStream, IOUtils.CHARSET_UTF_8));
            this.rates = new HashMap<String, Double>();
            block4: do {
                ev = this.parser.nextEvent();
                switch (ev) {
                    case 1: {
                        if (this.parser.wasKey()) {
                            String key = this.parser.getString();
                            if (key.equals("disclaimer")) {
                                this.parser.nextEvent();
                                this.disclaimer = this.parser.getString();
                                break;
                            }
                            if (key.equals("license")) {
                                this.parser.nextEvent();
                                this.license = this.parser.getString();
                                break;
                            }
                            if (key.equals("timestamp")) {
                                this.parser.nextEvent();
                                this.timestamp = this.parser.getLong();
                                break;
                            }
                            if (key.equals("base")) {
                                this.parser.nextEvent();
                                this.baseCurrency = this.parser.getString();
                                break;
                            }
                            if (key.equals("rates")) {
                                ev = this.parser.nextEvent();
                                assert (ev == 7);
                                ev = this.parser.nextEvent();
                                while (ev != 8) {
                                    String curr = this.parser.getString();
                                    ev = this.parser.nextEvent();
                                    Double rate = this.parser.getDouble();
                                    this.rates.put(curr, rate);
                                    ev = this.parser.nextEvent();
                                }
                                continue block4;
                            }
                            log.warn("Unknown key " + key);
                            break;
                        }
                        log.warn("Expected key, got " + JSONParser.getEventString((int)ev));
                        continue block4;
                    }
                    case 7: 
                    case 8: 
                    case 11: {
                        break;
                    }
                    default: {
                        log.info("Noggit UNKNOWN_EVENT_ID:" + JSONParser.getEventString((int)ev));
                    }
                }
            } while (ev != 11);
        }

        public Map<String, Double> getRates() {
            return this.rates;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public String getDisclaimer() {
            return this.disclaimer;
        }

        public String getBaseCurrency() {
            return this.baseCurrency;
        }

        public String getLicense() {
            return this.license;
        }
    }
}

