/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest.schema;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.BinaryQueryResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.servlet.ResponseUtils;
import org.apache.solr.util.FastWriter;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Status;
import org.restlet.representation.OutputRepresentation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;

abstract class BaseSchemaResource
extends ServerResource {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    protected static final String SHOW_DEFAULTS = "showDefaults";
    private SolrCore solrCore;
    private IndexSchema schema;
    private SolrQueryRequest solrRequest;
    private SolrQueryResponse solrResponse;
    private QueryResponseWriter responseWriter;
    private String contentType;
    private boolean doIndent = true;

    protected SolrCore getSolrCore() {
        return this.solrCore;
    }

    protected IndexSchema getSchema() {
        return this.schema;
    }

    protected SolrQueryRequest getSolrRequest() {
        return this.solrRequest;
    }

    protected SolrQueryResponse getSolrResponse() {
        return this.solrResponse;
    }

    protected String getContentType() {
        return this.contentType;
    }

    protected BaseSchemaResource() {
    }

    public void doInit() throws ResourceException {
        super.doInit();
        this.setNegotiated(false);
        if (this.isExisting()) {
            try {
                SolrRequestInfo solrRequestInfo = SolrRequestInfo.getRequestInfo();
                if (null == solrRequestInfo) {
                    String message = "No handler or core found in " + this.getRequest().getOriginalRef().getPath();
                    this.doError(Status.CLIENT_ERROR_BAD_REQUEST, message);
                    this.setExisting(false);
                } else {
                    this.solrRequest = solrRequestInfo.getReq();
                    if (null == this.solrRequest) {
                        String message = "No handler or core found in " + this.getRequest().getOriginalRef().getPath();
                        this.doError(Status.CLIENT_ERROR_BAD_REQUEST, message);
                        this.setExisting(false);
                    } else {
                        String indent;
                        this.solrResponse = solrRequestInfo.getRsp();
                        this.solrCore = this.solrRequest.getCore();
                        this.schema = this.solrRequest.getSchema();
                        String responseWriterName = this.solrRequest.getParams().get("wt");
                        if (null == responseWriterName) {
                            responseWriterName = "json";
                        }
                        if (null != (indent = this.solrRequest.getParams().get("indent")) && ("".equals(indent) || "off".equals(indent))) {
                            this.doIndent = false;
                        } else {
                            ModifiableSolrParams newParams = new ModifiableSolrParams(this.solrRequest.getParams());
                            newParams.remove(indent);
                            newParams.add("indent", new String[]{"on"});
                            this.solrRequest.setParams((SolrParams)newParams);
                        }
                        this.responseWriter = this.solrCore.getQueryResponseWriter(responseWriterName);
                        this.contentType = this.responseWriter.getContentType(this.solrRequest, this.solrResponse);
                        String path = this.getRequest().getRootRef().getPath();
                        if (!"/schema".equals(path)) {
                            int cutoffPoint = path.indexOf("/", 1);
                            String firstPathElement = -1 == cutoffPoint ? path : path.substring(0, cutoffPoint);
                            this.solrRequest.getContext().put("webapp", firstPathElement);
                        }
                        SolrCore.preDecorateResponse(this.solrRequest, this.solrResponse);
                    }
                }
            }
            catch (Throwable t) {
                if (t instanceof OutOfMemoryError) {
                    throw (OutOfMemoryError)t;
                }
                this.setExisting(false);
                throw new ResourceException(t);
            }
        }
    }

    protected void handlePostExecution(Logger log) {
        this.handleException(log);
        SolrCore.postDecorateResponse(null, this.solrRequest, this.solrResponse);
        if (log.isInfoEnabled() && this.solrResponse.getToLog().size() > 0) {
            log.info(this.solrResponse.getToLogAsString(this.solrCore.getLogId()));
        }
    }

    protected void handleException(Logger log) {
        Exception exception = this.getSolrResponse().getException();
        if (null != exception) {
            SimpleOrderedMap info = new SimpleOrderedMap();
            int code = ResponseUtils.getErrorInfo(exception, (NamedList)info, log);
            this.setStatus(Status.valueOf((int)code));
            this.getSolrResponse().add("error", info);
            String message = (String)info.get("msg");
            if (null != message && !message.trim().isEmpty()) {
                this.getSolrResponse().getToLog().add("msg", (Object)("{" + message.trim() + "}"));
            }
        }
    }

    protected static String urlDecode(String str) throws UnsupportedEncodingException {
        return URLDecoder.decode(str.replace("+", "%2B"), "UTF-8");
    }

    public class SolrOutputRepresentation
    extends OutputRepresentation {
        SolrOutputRepresentation() {
            super(MediaType.valueOf((String)BaseSchemaResource.this.contentType));
            BaseSchemaResource.this.getDimensions().clear();
        }

        public void write(OutputStream outputStream) throws IOException {
            if (BaseSchemaResource.this.getRequest().getMethod() != Method.HEAD) {
                if (BaseSchemaResource.this.responseWriter instanceof BinaryQueryResponseWriter) {
                    BinaryQueryResponseWriter binWriter = (BinaryQueryResponseWriter)BaseSchemaResource.this.responseWriter;
                    binWriter.write(outputStream, BaseSchemaResource.this.solrRequest, BaseSchemaResource.this.solrResponse);
                } else {
                    String charset = ContentStreamBase.getCharsetFromContentType((String)BaseSchemaResource.this.contentType);
                    Writer out = charset == null || charset.equalsIgnoreCase("UTF-8") ? new OutputStreamWriter(outputStream, UTF8) : new OutputStreamWriter(outputStream, charset);
                    out = new FastWriter(out);
                    BaseSchemaResource.this.responseWriter.write(out, BaseSchemaResource.this.solrRequest, BaseSchemaResource.this.solrResponse);
                    out.flush();
                }
            }
        }
    }
}

