/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2.nlp;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import company.evo.jmorphy2.nlp.Node;
import company.evo.jmorphy2.nlp.Parser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SubjectExtractor {
    private final Parser parser;
    private final boolean normalize;
    private List<Set<String>> enableExtractionValues;
    private List<Set<String>> disableExtractionValues;
    private List<Set<String>> subjValues;
    private static final Splitter partsSplitter = Splitter.on((String)" ").trimResults().omitEmptyStrings();
    private static final Splitter valuesSplitter = Splitter.on((String)",").trimResults().omitEmptyStrings();

    public SubjectExtractor(Parser parser, String confStr, boolean normalize) {
        this.parser = parser;
        this.normalize = normalize;
        this.loadConfigString(confStr);
    }

    private void loadConfigString(String confStr) {
        this.enableExtractionValues = new ArrayList<Set<String>>();
        this.disableExtractionValues = new ArrayList<Set<String>>();
        this.subjValues = new ArrayList<Set<String>>();
        for (String part : partsSplitter.split((CharSequence)confStr)) {
            if (part.startsWith("+")) {
                this.enableExtractionValues.add(this.parsePart(part.substring(1, part.length())));
                continue;
            }
            if (part.startsWith("-")) {
                this.disableExtractionValues.add(this.parsePart(part.substring(1, part.length())));
                continue;
            }
            this.subjValues.add(this.parsePart(part));
        }
    }

    private Set<String> parsePart(String part) {
        return ImmutableSet.copyOf((Iterable)valuesSplitter.split((CharSequence)part));
    }

    public List<String> extract(String[] tokens) throws IOException {
        return this.extract(this.parser.parse(tokens));
    }

    public List<String> extract(Node.Top sent) {
        ArrayList<String> results = new ArrayList<String>();
        for (Token token : this.extractTokens(sent)) {
            results.add(token.word);
        }
        return results;
    }

    public List<Token> extractTokens(String[] tokens) throws IOException {
        return this.extractTokens(this.parser.parse(tokens));
    }

    public List<Token> extractTokens(Node.Top sent) {
        ArrayList<Token> results = new ArrayList<Token>();
        this.fetchTokens(results, sent, 0, false, false);
        return results;
    }

    private int fetchTokens(List<Token> results, Node node, int index, boolean enabled, boolean disabled) {
        if (this.match(this.enableExtractionValues, (Set<String>)node.grammemeValues)) {
            enabled = true;
        }
        if (this.match(this.disableExtractionValues, (Set<String>)node.grammemeValues)) {
            disabled = true;
        }
        if (node.isLeaf()) {
            if (enabled && !disabled && this.match(this.subjValues, (Set<String>)node.grammemeValues)) {
                if (this.normalize && node.parsed != null) {
                    results.add(new Token(node.parsed.normalForm, index));
                } else {
                    results.add(new Token(node.word, index));
                }
            }
            return 1;
        }
        int ixInc = 0;
        for (Node child : node.getChildren()) {
            ixInc += this.fetchTokens(results, child, index + ixInc, enabled, disabled);
        }
        return ixInc;
    }

    private boolean match(List<Set<String>> matchValues, Set<String> values) {
        for (Set<String> testValues : matchValues) {
            if (!values.containsAll(testValues)) continue;
            return true;
        }
        return false;
    }

    public static class Token {
        public final String word;
        public final int index;

        public Token(String word, int index) {
            this.word = word;
            this.index = index;
        }

        public String toString() {
            return String.format("%s_%s", this.word, this.index);
        }
    }
}

