/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.tst;

import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class TestRequestHandler
implements SolrRequestHandler {
    private static Logger log = LoggerFactory.getLogger(SolrIndexSearcher.class);
    private long numRequests;
    private long numErrors;
    private final Pattern splitList = Pattern.compile(",| ");

    public void init(NamedList args) {
        SolrCore.log.info("Unused request handler arguments:" + args);
    }

    public void test(boolean condition) {
        try {
            if (!condition) {
                throw new RuntimeException("test requestHandler: assertion failed!");
            }
        }
        catch (RuntimeException e) {
            SolrException.log((Logger)log, (Throwable)e);
            throw e;
        }
    }

    public void handleRequest(SolrQueryRequest req, SolrQueryResponse rsp) {
        ++this.numRequests;
        try {
            ScoreDoc[] scoreDocs;
            int numHits;
            TopDocs hits;
            NamedList nl;
            String[] flst;
            String sreq = req.getQueryString();
            if (sreq == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing queryString");
            }
            List commands = StrUtils.splitSmart((String)sreq, (char)';');
            String qs = commands.size() >= 1 ? (String)commands.get(0) : "";
            Query query = QueryParsing.parseQuery(qs, req.getSchema());
            String fl = req.getParam("fl");
            int flags = 0;
            if (fl != null && (flst = this.splitList.split(fl, 0)).length > 0 && (flst.length != 1 || flst[0].length() != 0)) {
                HashSet<String> set = new HashSet<String>();
                for (String fname : flst) {
                    if ("score".equals(fname)) {
                        flags |= 1;
                    }
                    set.add(fname);
                }
                rsp.setReturnFields(set);
            }
            Sort sort = null;
            if (commands.size() >= 2) {
                sort = QueryParsing.parseSort((String)commands.get(1), req);
            }
            SolrIndexSearcher searcher = req.getSearcher();
            int start = req.getStart();
            int limit = req.getLimit();
            Query filterQuery = null;
            DocSet filter = null;
            Filter lfilter = null;
            DocList results = req.getSearcher().getDocList(query, null, sort, req.getStart(), req.getLimit(), flags);
            rsp.add(null, results);
            if (qs.startsWith("values")) {
                rsp.add("testname1", "testval1");
                rsp.add("testarr1", new String[]{"my val 1", "my val 2"});
                nl = new NamedList();
                nl.add("myInt", (Object)333);
                nl.add("myNullVal", null);
                nl.add("myFloat", (Object)Float.valueOf(1.4142135f));
                nl.add("myDouble", (Object)1.0E100);
                nl.add("myBool", (Object)false);
                nl.add("myLong", (Object)999999999999L);
                Document doc = new Document();
                doc.add((Fieldable)new Field("id", "55", Field.Store.YES, Field.Index.NOT_ANALYZED));
                nl.add("myDoc", (Object)doc);
                nl.add("myResult", (Object)results);
                nl.add("myStr", (Object)"&wow! test escaping: a&b<c&");
                nl.add(null, (Object)"this value had a null name...");
                nl.add("myIntArray", (Object)new Integer[]{100, 5, -10, 42});
                nl.add("epoch", (Object)new Date(0L));
                nl.add("currDate", (Object)new Date(System.currentTimeMillis()));
                rsp.add("myNamedList", nl);
            } else if (qs.startsWith("fields")) {
                nl = new NamedList();
                Collection flst2 = searcher.getReader().getFieldNames(IndexReader.FieldOption.INDEXED);
                nl.add("indexed", (Object)flst2);
                flst2 = searcher.getReader().getFieldNames(IndexReader.FieldOption.UNINDEXED);
                nl.add("unindexed", (Object)flst2);
                rsp.add("fields", nl);
            }
            this.test(results.size() <= limit);
            this.test(results.size() <= results.matches());
            this.test(start == 0 && limit >= results.matches() ? results.size() == results.matches() : true);
            if (sort != null) {
                hits = searcher.search(query, lfilter, 1000, sort);
                numHits = hits.totalHits;
                scoreDocs = hits.scoreDocs;
            } else {
                hits = searcher.search(query, lfilter, 1000);
                numHits = hits.totalHits;
                scoreDocs = hits.scoreDocs;
            }
            this.test(numHits == results.matches());
            DocList rrr2 = results.subset(start, limit);
            this.test(rrr2 == results);
            DocIterator iter = results.iterator();
            for (int i = 0; i < results.size(); ++i) {
                this.test(iter.nextDoc() == scoreDocs[i].doc);
            }
            DocList results2 = req.getSearcher().getDocList(query, query, sort, start, limit);
            this.test(results2.size() == results.size() && results2.matches() == results.matches());
            DocList results3 = req.getSearcher().getDocList(query, query, null, start, limit);
            this.test(results3.size() == results.size() && results3.matches() == results.matches());
            DocListAndSet both = searcher.getDocListAndSet(query, filter, sort, start, limit);
            this.test(both.docList.equals(results));
            this.test(both.docList.matches() == both.docSet.size());
            this.test(start == 0 && both.docSet.size() <= limit ? both.docSet.equals(both.docList) : true);
            DocListAndSet both2 = searcher.getDocListAndSet(query, both.docSet, sort, start, limit);
            this.test(both2.docList.equals(both.docList));
            this.test(both2.docSet.equals(both.docSet));
            DocListAndSet both3 = searcher.getDocListAndSet(query, query, sort, start, limit);
            this.test(both3.docList.equals(both.docList));
            this.test(both3.docSet.equals(both.docSet));
            OpenBitSet bits = both.docSet.getBits();
            OpenBitSet neg = (OpenBitSet)bits.clone();
            neg.flip(0L, bits.capacity());
            both2 = searcher.getDocListAndSet(query, new BitDocSet(neg), sort, start, limit);
            this.test(both2.docList.size() == 0);
            this.test(both2.docList.matches() == 0);
            this.test(both2.docSet.size() == 0);
            DocSet allResults = searcher.getDocSet(query, filter);
            this.test(allResults.equals(both.docSet));
            if (filter != null) {
                DocSet res = searcher.getDocSet(query);
                this.test(res.size() >= results.size());
                this.test(res.intersection(filter).equals(both.docSet));
                this.test(res.intersectionSize(filter) == both.docSet.size());
                if (filterQuery != null) {
                    this.test(searcher.numDocs(filterQuery, res) == both.docSet.size());
                }
            }
        }
        catch (Exception e) {
            rsp.setException(e);
            ++this.numErrors;
            return;
        }
    }

    public String getName() {
        return TestRequestHandler.class.getName();
    }

    public String getVersion() {
        return "1.0";
    }

    public String getDescription() {
        return "A test handler that runs some sanity checks on results";
    }

    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.QUERYHANDLER;
    }

    public String getSourceId() {
        return "$Id: TestRequestHandler.java 1003745 2010-10-02 05:52:12Z koji $";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_3_3/solr/src/java/org/apache/solr/tst/TestRequestHandler.java $";
    }

    public URL[] getDocs() {
        return null;
    }

    public NamedList getStatistics() {
        NamedList lst = new NamedList();
        lst.add("requests", (Object)this.numRequests);
        lst.add("errors", (Object)this.numErrors);
        return lst;
    }
}

