/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.spatial.DistanceUtils;
import org.apache.lucene.spatial.tier.InvalidGeoException;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.response.XMLWriter;
import org.apache.solr.schema.AbstractSubTypeFieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.LatLonValueSource;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SpatialDistanceQuery;
import org.apache.solr.schema.SpatialQueryable;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SpatialOptions;
import org.apache.solr.search.function.ValueSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatLonType
extends AbstractSubTypeFieldType
implements SpatialQueryable {
    protected static final int LAT = 0;
    protected static final int LONG = 1;

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        super.init(schema, args);
        this.createSuffixCache(3);
    }

    @Override
    public Fieldable[] createFields(SchemaField field, String externalVal, float boost) {
        Fieldable[] f = new Fieldable[(field.indexed() ? 2 : 0) + (field.stored() ? 1 : 0)];
        if (field.indexed()) {
            int i = 0;
            double[] latLon = new double[]{};
            try {
                latLon = DistanceUtils.parseLatitudeLongitude(null, (String)externalVal);
            }
            catch (InvalidGeoException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
            f[i] = this.subField(field, i).createField(String.valueOf(latLon[0]), boost);
            f[++i] = this.subField(field, i).createField(String.valueOf(latLon[1]), boost);
        }
        if (field.stored()) {
            f[f.length - 1] = this.createField(field.getName(), externalVal, this.getFieldStore(field, externalVal), Field.Index.NO, Field.TermVector.NO, false, false, boost);
        }
        return f;
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        String[] p2;
        String[] p1;
        int dimension = 2;
        try {
            p1 = DistanceUtils.parsePoint(null, (String)part1, (int)dimension);
            p2 = DistanceUtils.parsePoint(null, (String)part2, (int)dimension);
        }
        catch (InvalidGeoException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        BooleanQuery result = new BooleanQuery(true);
        for (int i = 0; i < dimension; ++i) {
            SchemaField subSF = this.subField(field, i);
            result.add(subSF.getType().getRangeQuery(parser, subSF, p1[i], p2[i], minInclusive, maxInclusive), BooleanClause.Occur.MUST);
        }
        return result;
    }

    @Override
    public Query getFieldQuery(QParser parser, SchemaField field, String externalVal) {
        int dimension = 2;
        String[] p1 = new String[]{};
        try {
            p1 = DistanceUtils.parsePoint(null, (String)externalVal, (int)dimension);
        }
        catch (InvalidGeoException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        BooleanQuery bq = new BooleanQuery(true);
        for (int i = 0; i < dimension; ++i) {
            SchemaField sf = this.subField(field, i);
            Query tq = sf.getType().getFieldQuery(parser, sf, p1[i]);
            bq.add(tq, BooleanClause.Occur.MUST);
        }
        return bq;
    }

    @Override
    public Query createSpatialQuery(QParser parser, SpatialOptions options) {
        double[] point = null;
        try {
            point = DistanceUtils.parseLatitudeLongitude((String)options.pointStr);
        }
        catch (InvalidGeoException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        double latCenter = point[0];
        double lonCenter = point[1];
        point[0] = point[0] * (Math.PI / 180);
        point[1] = point[1] * (Math.PI / 180);
        double[] tmp = new double[2];
        double[] north = DistanceUtils.pointOnBearing((double)point[0], (double)point[1], (double)options.distance, (double)0.0, (double[])tmp, (double)options.radius);
        double ur_lat = north[0] * 57.29577951308232;
        double[] east = DistanceUtils.pointOnBearing((double)point[0], (double)point[1], (double)options.distance, (double)1.5707963267948966, (double[])tmp, (double)options.radius);
        double ur_lon = east[1] * 57.29577951308232;
        double[] south = DistanceUtils.pointOnBearing((double)point[0], (double)point[1], (double)options.distance, (double)Math.PI, (double[])tmp, (double)options.radius);
        double ll_lat = south[0] * 57.29577951308232;
        double[] west = DistanceUtils.pointOnBearing((double)point[0], (double)point[1], (double)options.distance, (double)4.71238898038469, (double[])tmp, (double)options.radius);
        double ll_lon = west[1] * 57.29577951308232;
        double angDist = DistanceUtils.angularDistance((double)options.distance, (double)options.radius);
        double latMin = -90.0;
        double latMax = 90.0;
        double lonMin = -180.0;
        double lonMax = 180.0;
        double lon2Min = -180.0;
        double lon2Max = 180.0;
        if (point[0] + angDist > 1.5707963267948966) {
            latMin = Math.min(ll_lat, ur_lat);
        } else if (point[0] - angDist < -1.5707963267948966) {
            latMax = Math.max(ll_lat, ur_lat);
        } else {
            latMin = ll_lat;
            latMax = ur_lat;
            if (ll_lon > ur_lon) {
                lonMin = -180.0;
                lonMax = ur_lon;
                lon2Min = ll_lon;
                lon2Max = 180.0;
            } else {
                lonMin = ll_lon;
                lonMax = ur_lon;
            }
        }
        SchemaField latField = this.subField(options.field, 0);
        SchemaField lonField = this.subField(options.field, 1);
        if (options.bbox) {
            BooleanQuery result = new BooleanQuery();
            Query latRange = latField.getType().getRangeQuery(parser, latField, String.valueOf(latMin), String.valueOf(latMax), true, true);
            result.add(latRange, BooleanClause.Occur.MUST);
            if (lonMin != -180.0 || lonMax != 180.0) {
                Query lonRange = lonField.getType().getRangeQuery(parser, lonField, String.valueOf(lonMin), String.valueOf(lonMax), true, true);
                if (lon2Min != -180.0 || lon2Max != 180.0) {
                    BooleanQuery bothLons = new BooleanQuery();
                    bothLons.add(lonRange, BooleanClause.Occur.SHOULD);
                    lonRange = lonField.getType().getRangeQuery(parser, lonField, String.valueOf(lon2Min), String.valueOf(lon2Max), true, true);
                    bothLons.add(lonRange, BooleanClause.Occur.SHOULD);
                    lonRange = bothLons;
                }
                result.add(lonRange, BooleanClause.Occur.MUST);
            }
            return result;
        }
        SpatialDistanceQuery spatial = new SpatialDistanceQuery();
        spatial.origField = options.field.getName();
        spatial.latSource = latField.getType().getValueSource(latField, parser);
        spatial.lonSource = lonField.getType().getValueSource(lonField, parser);
        spatial.latMin = latMin;
        spatial.latMax = latMax;
        spatial.lonMin = lonMin;
        spatial.lonMax = lonMax;
        spatial.lon2Min = lon2Min;
        spatial.lon2Max = lon2Max;
        spatial.lon2 = lon2Min != -180.0 || lon2Max != 180.0;
        spatial.latCenter = latCenter;
        spatial.lonCenter = lonCenter;
        spatial.dist = options.distance;
        spatial.planetRadius = options.radius;
        spatial.calcDist = !options.bbox;
        return spatial;
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser parser) {
        ArrayList<ValueSource> vs = new ArrayList<ValueSource>(2);
        for (int i = 0; i < 2; ++i) {
            SchemaField sub = this.subField(field, i);
            vs.add(sub.getType().getValueSource(sub, parser));
        }
        return new LatLonValueSource(field, vs);
    }

    @Override
    public boolean isPolyField() {
        return true;
    }

    @Override
    public void write(XMLWriter xmlWriter, String name, Fieldable f) throws IOException {
        xmlWriter.writeStr(name, f.stringValue());
    }

    @Override
    public void write(TextResponseWriter writer, String name, Fieldable f) throws IOException {
        writer.writeStr(name, f.stringValue(), false);
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Sorting not supported on SpatialTileField " + field.getName());
    }

    @Override
    public Fieldable createField(SchemaField field, String externalVal, float boost) {
        throw new UnsupportedOperationException("SpatialTileField uses multiple fields.  field=" + field.getName());
    }
}

