/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.HighFrequencyDictionary;
import org.apache.lucene.search.spell.SpellChecker;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SpellCheckerRequestHandler
extends RequestHandlerBase
implements SolrCoreAware {
    private static Logger log = LoggerFactory.getLogger(SpellCheckerRequestHandler.class);
    private SpellChecker spellChecker;
    protected Directory spellcheckerIndexDir = new RAMDirectory();
    protected String dirDescription = "(ramdir)";
    protected String termSourceField;
    protected static final String PREFIX = "sp.";
    protected static final String QUERY_PREFIX = "sp.query.";
    protected static final String DICTIONARY_PREFIX = "sp.dictionary.";
    protected static final String SOURCE_FIELD = "sp.dictionary.termSourceField";
    protected static final String INDEX_DIR = "sp.dictionary.indexDir";
    protected static final String THRESHOLD = "sp.dictionary.threshold";
    protected static final String ACCURACY = "sp.query.accuracy";
    protected static final String SUGGESTIONS = "sp.query.suggestionCount";
    protected static final String POPULAR = "sp.query.onlyMorePopular";
    protected static final String EXTENDED = "sp.query.extendedResults";
    protected static final float DEFAULT_ACCURACY = 0.5f;
    protected static final int DEFAULT_SUGGESTION_COUNT = 1;
    protected static final boolean DEFAULT_MORE_POPULAR = false;
    protected static final boolean DEFAULT_EXTENDED_RESULTS = false;
    protected static final float DEFAULT_DICTIONARY_THRESHOLD = 0.0f;
    protected SolrParams args = null;

    public void init(NamedList args) {
        super.init(args);
        this.args = SolrParams.toSolrParams((NamedList)args);
    }

    public void inform(SolrCore core) {
        this.termSourceField = this.args.get(SOURCE_FIELD, this.args.get("termSourceField"));
        try {
            String dir = this.args.get(INDEX_DIR, this.args.get("spellcheckerIndexDir"));
            if (null != dir) {
                File f = new File(dir);
                if (!f.isAbsolute()) {
                    f = new File(core.getDataDir(), dir);
                }
                this.dirDescription = f.getAbsolutePath();
                log.info("using spell directory: " + this.dirDescription);
                this.spellcheckerIndexDir = FSDirectory.open((File)f);
            } else {
                log.info("using RAM based spell directory");
            }
            this.spellChecker = new SpellChecker(this.spellcheckerIndexDir);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot open SpellChecker index", e);
        }
    }

    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        boolean extendedResults;
        boolean onlyMorePopular;
        int numSug;
        SolrParams p = req.getParams();
        String words = p.get("q");
        String cmd = p.get("cmd");
        if (cmd != null) {
            if ((cmd = cmd.trim()).equals("rebuild")) {
                this.rebuild(req);
                rsp.add("cmdExecuted", "rebuild");
            } else if (cmd.equals("reopen")) {
                this.reopen();
                rsp.add("cmdExecuted", "reopen");
            } else {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unrecognized Command: " + cmd);
            }
        }
        if (null == words || "".equals(words.trim())) {
            return;
        }
        SolrIndexReader indexReader = null;
        String suggestionField = null;
        try {
            Float accuracy = Float.valueOf(p.getFloat(ACCURACY, p.getFloat("accuracy", 0.5f)));
            this.spellChecker.setAccuracy(accuracy.floatValue());
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Accuracy must be a valid positive float", e);
        }
        try {
            numSug = p.getInt(SUGGESTIONS, p.getInt("suggestionCount", 1));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Spelling suggestion count must be a valid positive integer", e);
        }
        try {
            onlyMorePopular = p.getBool(POPULAR, false);
        }
        catch (SolrException e) {
            throw new RuntimeException("'Only more popular' must be a valid boolean", e);
        }
        try {
            extendedResults = p.getBool(EXTENDED, false);
        }
        catch (SolrException e) {
            throw new RuntimeException("'Extended results' must be a valid boolean", e);
        }
        if (onlyMorePopular || extendedResults) {
            indexReader = req.getSearcher().getReader();
            suggestionField = this.termSourceField;
        }
        if (extendedResults) {
            String[] wordz;
            rsp.add("numDocs", indexReader.numDocs());
            SimpleOrderedMap results = new SimpleOrderedMap();
            for (String word : wordz = words.split(" ")) {
                SimpleOrderedMap nl = new SimpleOrderedMap();
                nl.add("frequency", (Object)indexReader.docFreq(new Term(suggestionField, word)));
                String[] suggestions = this.spellChecker.suggestSimilar(word, numSug, (IndexReader)indexReader, suggestionField, onlyMorePopular);
                NamedList sa = new NamedList();
                for (int i = 0; i < suggestions.length; ++i) {
                    SimpleOrderedMap si = new SimpleOrderedMap();
                    si.add("frequency", (Object)indexReader.docFreq(new Term(this.termSourceField, suggestions[i])));
                    sa.add(suggestions[i], (Object)si);
                }
                nl.add("suggestions", (Object)sa);
                results.add(word, (Object)nl);
            }
            rsp.add("result", results);
        } else {
            rsp.add("words", words);
            if (this.spellChecker.exist(words)) {
                rsp.add("exist", "true");
            } else {
                rsp.add("exist", "false");
            }
            String[] suggestions = this.spellChecker.suggestSimilar(words, numSug, (IndexReader)indexReader, suggestionField, onlyMorePopular);
            rsp.add("suggestions", Arrays.asList(suggestions));
        }
    }

    protected Dictionary getDictionary(SolrQueryRequest req) {
        float threshold;
        try {
            threshold = req.getParams().getFloat(THRESHOLD, 0.0f);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Threshold must be a valid positive float", e);
        }
        SolrIndexReader indexReader = req.getSearcher().getReader();
        return new HighFrequencyDictionary((IndexReader)indexReader, this.termSourceField, threshold);
    }

    private void rebuild(SolrQueryRequest req) throws IOException, SolrException {
        if (null == this.termSourceField) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "can't rebuild spellchecker index without termSourceField configured");
        }
        Dictionary dictionary = this.getDictionary(req);
        this.spellChecker.clearIndex();
        this.spellChecker.indexDictionary(dictionary);
        this.reopen();
    }

    private void reopen() throws IOException {
        this.spellChecker.setSpellIndex(this.spellcheckerIndexDir);
    }

    public String getVersion() {
        return "$Revision: 1130612 $";
    }

    public String getDescription() {
        return "The SpellChecker Solr request handler for SpellChecker index: " + this.dirDescription;
    }

    public String getSourceId() {
        return "$Id: SpellCheckerRequestHandler.java 1130612 2011-06-02 15:51:21Z rmuir $";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_3_3/solr/src/java/org/apache/solr/handler/SpellCheckerRequestHandler.java $";
    }

    public URL[] getDocs() {
        return null;
    }
}

