/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.analysis.SynonymFilter;
import org.apache.solr.analysis.SynonymMap;
import org.apache.solr.analysis.TokenizerFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.util.plugin.ResourceLoaderAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynonymFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    private SynonymMap synMap;

    @Override
    public void inform(ResourceLoader loader) {
        String synonyms = (String)this.args.get("synonyms");
        if (synonyms == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing required argument 'synonyms'.");
        }
        boolean ignoreCase = this.getBoolean("ignoreCase", false);
        boolean expand = this.getBoolean("expand", true);
        String tf = (String)this.args.get("tokenizerFactory");
        TokenizerFactory tokFactory = null;
        if (tf != null) {
            tokFactory = SynonymFilterFactory.loadTokenizerFactory(loader, tf, this.args);
        }
        Iterable<String> wlist = this.loadRules(synonyms, loader);
        this.synMap = new SynonymMap(ignoreCase);
        SynonymFilterFactory.parseRules(wlist, this.synMap, "=>", ",", expand, tokFactory);
    }

    protected Iterable<String> loadRules(String synonyms, ResourceLoader loader) {
        ArrayList<String> wlist = null;
        try {
            File synonymFile = new File(synonyms);
            if (synonymFile.exists()) {
                wlist = loader.getLines(synonyms);
            } else {
                List files = StrUtils.splitFileNames((String)synonyms);
                wlist = new ArrayList<String>();
                for (String file : files) {
                    List lines = loader.getLines(file.trim());
                    wlist.addAll(lines);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return wlist;
    }

    static void parseRules(Iterable<String> rules, SynonymMap map, String mappingSep, String synSep, boolean expansion, TokenizerFactory tokFactory) {
        int count = 0;
        for (String rule : rules) {
            List<List<String>> target;
            List<List<String>> source;
            List mapping = StrUtils.splitSmart((String)rule, (String)mappingSep, (boolean)false);
            if (mapping.size() > 2) {
                throw new RuntimeException("Invalid Synonym Rule:" + rule);
            }
            if (mapping.size() == 2) {
                source = SynonymFilterFactory.getSynList((String)mapping.get(0), synSep, tokFactory);
                target = SynonymFilterFactory.getSynList((String)mapping.get(1), synSep, tokFactory);
            } else {
                source = SynonymFilterFactory.getSynList((String)mapping.get(0), synSep, tokFactory);
                if (expansion) {
                    target = source;
                } else {
                    target = new ArrayList<List<String>>(1);
                    target.add(source.get(0));
                }
            }
            boolean includeOrig = false;
            for (List<String> fromToks : source) {
                ++count;
                for (List<String> toToks : target) {
                    map.add(fromToks, SynonymMap.makeTokens(toToks), includeOrig, true);
                }
            }
        }
    }

    private static List<List<String>> getSynList(String str, String separator, TokenizerFactory tokFactory) {
        List strList = StrUtils.splitSmart((String)str, (String)separator, (boolean)false);
        ArrayList<List<String>> synList = new ArrayList<List<String>>();
        for (String toks : strList) {
            List<String> tokList = tokFactory == null ? StrUtils.splitWS((String)toks, (boolean)true) : SynonymFilterFactory.splitByTokenizer(toks, tokFactory);
            synList.add(tokList);
        }
        return synList;
    }

    private static List<String> splitByTokenizer(String source, TokenizerFactory tokFactory) {
        StringReader reader = new StringReader(source);
        TokenStream ts = SynonymFilterFactory.loadTokenizer(tokFactory, reader);
        ArrayList<String> tokList = new ArrayList<String>();
        try {
            try {
                CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
                while (ts.incrementToken()) {
                    if (termAtt.length() <= 0) continue;
                    tokList.add(termAtt.toString());
                }
                Object var7_7 = null;
                reader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            reader.close();
            throw throwable;
        }
        return tokList;
    }

    private static TokenizerFactory loadTokenizerFactory(ResourceLoader loader, String cname, Map<String, String> args) {
        TokenizerFactory tokFactory = (TokenizerFactory)loader.newInstance(cname, new String[0]);
        tokFactory.init(args);
        return tokFactory;
    }

    private static TokenStream loadTokenizer(TokenizerFactory tokFactory, Reader reader) {
        return tokFactory.create(reader);
    }

    public SynonymMap getSynonymMap() {
        return this.synMap;
    }

    public SynonymFilter create(TokenStream input) {
        return new SynonymFilter(input, this.synMap);
    }
}

