/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.examples.wc;

import java.io.File;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.examples.wc.UpdateEventHandler;

public class WorkingCopy {
    private static SVNClientManager ourClientManager;
    private static ISVNEventHandler myUpdateEventHandler;
    JTextArea messageTextArea;

    public void Download(JTextArea messageArea, String svnURL, String destination, String extensionName) throws SVNException {
        this.messageTextArea = messageArea;
        WorkingCopy.setupLibrary();
        SVNURL repositoryURL = null;
        try {
            repositoryURL = SVNURL.parseURIEncoded((String)svnURL);
        }
        catch (SVNException e) {
            e.printStackTrace();
        }
        String name = "";
        String password = "";
        String myWorkingCopyPath = destination;
        SVNURL url = repositoryURL;
        myUpdateEventHandler = new UpdateEventHandler(this.messageTextArea, destination, extensionName);
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        ourClientManager = SVNClientManager.newInstance((DefaultSVNOptions)options, (String)name, (String)password);
        ourClientManager.getUpdateClient().setEventHandler(myUpdateEventHandler);
        File wcDir = new File(myWorkingCopyPath);
        if (wcDir.exists()) {
            Object[] option = new Object[]{"Remove it!", "Keep it!"};
            int n = JOptionPane.showOptionDialog(new JFrame(), "The folder '" + wcDir.getAbsolutePath() + "' already exists!", "Attention", 1, 3, null, option, option[0]);
            if (n == 0) {
                WorkingCopy.deleteDir(wcDir);
            } else {
                return;
            }
        }
        wcDir.mkdirs();
        this.messageTextArea.append("Checking out a working copy from '" + url + "'...\n");
        try {
            WorkingCopy.checkout(url, SVNRevision.HEAD, wcDir, true);
        }
        catch (SVNException svne) {
            WorkingCopy.error("error while checking out a working copy for the location '" + url + "'", (Exception)((Object)svne));
        }
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = WorkingCopy.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    private static void setupLibrary() {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }

    private static void checkout(SVNURL url, SVNRevision revision, File destPath, boolean isRecursive) throws SVNException {
        SVNUpdateClient updateClient = ourClientManager.getUpdateClient();
        updateClient.setIgnoreExternals(false);
        long x = updateClient.doCheckout(url, destPath, revision, revision, isRecursive);
    }

    private static void error(String message, Exception e) {
        System.err.println(String.valueOf(message) + (e != null ? ": " + e.getMessage() : ""));
        System.exit(1);
    }
}

