/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import jdbm.recman.BlockIo;
import jdbm.recman.DataPage;
import jdbm.recman.FreePhysicalRowIdPageManager;
import jdbm.recman.Location;
import jdbm.recman.PageCursor;
import jdbm.recman.PageManager;
import jdbm.recman.RecordFile;
import jdbm.recman.RecordHeader;

final class PhysicalRowIdManager {
    private RecordFile file;
    private PageManager pageman;
    private FreePhysicalRowIdPageManager freeman;

    PhysicalRowIdManager(RecordFile recordFile, PageManager pageManager) throws IOException {
        this.file = recordFile;
        this.pageman = pageManager;
        this.freeman = new FreePhysicalRowIdPageManager(recordFile, this.pageman);
    }

    Location insert(byte[] byArray, int n, int n2) throws IOException {
        Location location = this.alloc(n2);
        this.write(location, byArray, n, n2);
        return location;
    }

    Location update(Location location, byte[] byArray, int n, int n2) throws IOException {
        BlockIo blockIo = this.file.get(location.getBlock());
        RecordHeader recordHeader = new RecordHeader(blockIo, location.getOffset());
        if (n2 > recordHeader.getAvailableSize()) {
            this.file.release(blockIo);
            this.free(location);
            location = this.alloc(n2);
        } else {
            this.file.release(blockIo);
        }
        this.write(location, byArray, n, n2);
        return location;
    }

    void delete(Location location) throws IOException {
        this.free(location);
    }

    byte[] fetch(Location location) throws IOException {
        PageCursor pageCursor = new PageCursor(this.pageman, location.getBlock());
        BlockIo blockIo = this.file.get(pageCursor.getCurrent());
        RecordHeader recordHeader = new RecordHeader(blockIo, location.getOffset());
        byte[] byArray = new byte[recordHeader.getCurrentSize()];
        if (byArray.length == 0) {
            this.file.release(pageCursor.getCurrent(), false);
            return byArray;
        }
        int n = 0;
        int n2 = byArray.length;
        int n3 = location.getOffset() + 8;
        while (n2 > 0) {
            int n4 = 8192 - n3;
            if (n2 < n4) {
                n4 = n2;
            }
            System.arraycopy(blockIo.getData(), n3, byArray, n, n4);
            n += n4;
            this.file.release(blockIo);
            if ((n2 -= n4) <= 0) continue;
            blockIo = this.file.get(pageCursor.next());
            n3 = 20;
        }
        return byArray;
    }

    private Location alloc(int n) throws IOException {
        Location location = this.freeman.get(n);
        if (location == null) {
            location = this.allocNew(n, this.pageman.getLast((short)1));
        }
        return location;
    }

    private Location allocNew(int n, long l) throws IOException {
        DataPage dataPage;
        BlockIo blockIo;
        if (l == 0L) {
            l = this.pageman.allocate((short)1);
            blockIo = this.file.get(l);
            dataPage = DataPage.getDataPageView(blockIo);
            dataPage.setFirst((short)20);
            RecordHeader recordHeader = new RecordHeader(blockIo, 20);
            recordHeader.setAvailableSize(0);
            recordHeader.setCurrentSize(0);
        } else {
            blockIo = this.file.get(l);
            dataPage = DataPage.getDataPageView(blockIo);
        }
        short s = dataPage.getFirst();
        if (s == 0) {
            this.file.release(blockIo);
            return this.allocNew(n, 0L);
        }
        RecordHeader recordHeader = new RecordHeader(blockIo, s);
        while (recordHeader.getAvailableSize() != 0 && s < 8192) {
            if ((s = (short)(s + (recordHeader.getAvailableSize() + 8))) == 8192) {
                this.file.release(blockIo);
                return this.allocNew(n, 0L);
            }
            recordHeader = new RecordHeader(blockIo, s);
        }
        if (s == 8) {
            this.file.release(blockIo);
        }
        Location location = new Location(l, s);
        int n2 = 8192 - s - 8;
        if (n2 < n) {
            int n3;
            int n4 = (n - n2) % 8172;
            if (8172 - n4 < 24) {
                n += 8172 - n4;
            }
            recordHeader.setAvailableSize(n);
            this.file.release(l, true);
            for (n3 = n - n2; n3 >= 8172; n3 -= 8172) {
                l = this.pageman.allocate((short)1);
                blockIo = this.file.get(l);
                dataPage = DataPage.getDataPageView(blockIo);
                dataPage.setFirst((short)0);
                this.file.release(l, true);
            }
            if (n3 > 0) {
                l = this.pageman.allocate((short)1);
                blockIo = this.file.get(l);
                dataPage = DataPage.getDataPageView(blockIo);
                dataPage.setFirst((short)(20 + n3));
                this.file.release(l, true);
            }
        } else {
            if (n2 - n <= 24) {
                n = n2;
            }
            recordHeader.setAvailableSize(n);
            this.file.release(l, true);
        }
        return location;
    }

    private void free(Location location) throws IOException {
        BlockIo blockIo = this.file.get(location.getBlock());
        DataPage dataPage = DataPage.getDataPageView(blockIo);
        RecordHeader recordHeader = new RecordHeader(blockIo, location.getOffset());
        recordHeader.setCurrentSize(0);
        this.file.release(location.getBlock(), true);
        this.freeman.put(location, recordHeader.getAvailableSize());
    }

    private void write(Location location, byte[] byArray, int n, int n2) throws IOException {
        PageCursor pageCursor = new PageCursor(this.pageman, location.getBlock());
        BlockIo blockIo = this.file.get(pageCursor.getCurrent());
        RecordHeader recordHeader = new RecordHeader(blockIo, location.getOffset());
        recordHeader.setCurrentSize(n2);
        if (n2 == 0) {
            this.file.release(pageCursor.getCurrent(), true);
            return;
        }
        int n3 = n;
        int n4 = n2;
        int n5 = location.getOffset() + 8;
        while (n4 > 0) {
            int n6 = 8192 - n5;
            if (n4 < n6) {
                n6 = n4;
            }
            System.arraycopy(byArray, n3, blockIo.getData(), n5, n6);
            n3 += n6;
            this.file.release(pageCursor.getCurrent(), true);
            if ((n4 -= n6) <= 0) continue;
            blockIo = this.file.get(pageCursor.next());
            n5 = 20;
        }
    }
}

