/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import jdbm.recman.BlockIo;
import jdbm.recman.FileHeader;
import jdbm.recman.PageHeader;
import jdbm.recman.RecordFile;

final class PageManager {
    private RecordFile file;
    private FileHeader header;
    private BlockIo headerBuf;

    PageManager(RecordFile recordFile) throws IOException {
        this.file = recordFile;
        this.headerBuf = recordFile.get(0L);
        this.header = this.headerBuf.readShort(0) == 0 ? new FileHeader(this.headerBuf, true) : new FileHeader(this.headerBuf, false);
    }

    long allocate(short s) throws IOException {
        if (s == 0) {
            throw new Error("allocate of free page?");
        }
        long l = this.header.getFirstOf(0);
        boolean bl = false;
        if (l != 0L) {
            this.header.setFirstOf(0, this.getNext(l));
        } else {
            l = this.header.getLastOf(0);
            if (l == 0L) {
                l = 1L;
            }
            this.header.setLastOf(0, l + 1L);
            bl = true;
        }
        BlockIo blockIo = this.file.get(l);
        PageHeader pageHeader = bl ? new PageHeader(blockIo, s) : PageHeader.getView(blockIo);
        long l2 = this.header.getLastOf(s);
        System.arraycopy(RecordFile.cleanData, 0, blockIo.getData(), 0, 8192);
        pageHeader.setType(s);
        pageHeader.setPrev(l2);
        pageHeader.setNext(0L);
        if (l2 == 0L) {
            this.header.setFirstOf(s, l);
        }
        this.header.setLastOf(s, l);
        this.file.release(l, true);
        if (l2 != 0L) {
            blockIo = this.file.get(l2);
            pageHeader = PageHeader.getView(blockIo);
            pageHeader.setNext(l);
            this.file.release(l2, true);
        }
        blockIo.setView(null);
        return l;
    }

    void free(short s, long l) throws IOException {
        if (s == 0) {
            throw new Error("free free page?");
        }
        if (l == 0L) {
            throw new Error("free header page?");
        }
        BlockIo blockIo = this.file.get(l);
        PageHeader pageHeader = PageHeader.getView(blockIo);
        long l2 = pageHeader.getPrev();
        long l3 = pageHeader.getNext();
        pageHeader.setType((short)0);
        pageHeader.setNext(this.header.getFirstOf(0));
        pageHeader.setPrev(0L);
        this.header.setFirstOf(0, l);
        this.file.release(l, true);
        if (l2 != 0L) {
            blockIo = this.file.get(l2);
            pageHeader = PageHeader.getView(blockIo);
            pageHeader.setNext(l3);
            this.file.release(l2, true);
        } else {
            this.header.setFirstOf(s, l3);
        }
        if (l3 != 0L) {
            blockIo = this.file.get(l3);
            pageHeader = PageHeader.getView(blockIo);
            pageHeader.setPrev(l2);
            this.file.release(l3, true);
        } else {
            this.header.setLastOf(s, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getNext(long l) throws IOException {
        try {
            long l2 = PageHeader.getView(this.file.get(l)).getNext();
            return l2;
        }
        finally {
            this.file.release(l, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getPrev(long l) throws IOException {
        try {
            long l2 = PageHeader.getView(this.file.get(l)).getPrev();
            return l2;
        }
        finally {
            this.file.release(l, false);
        }
    }

    long getFirst(short s) throws IOException {
        return this.header.getFirstOf(s);
    }

    long getLast(short s) throws IOException {
        return this.header.getLastOf(s);
    }

    void commit() throws IOException {
        this.file.release(this.headerBuf);
        this.file.commit();
        this.headerBuf = this.file.get(0L);
        this.header = new FileHeader(this.headerBuf, false);
    }

    void rollback() throws IOException {
        this.file.discard(this.headerBuf);
        this.file.rollback();
        this.headerBuf = this.file.get(0L);
        this.header = this.headerBuf.readShort(0) == 0 ? new FileHeader(this.headerBuf, true) : new FileHeader(this.headerBuf, false);
    }

    void close() throws IOException {
        this.file.release(this.headerBuf);
        this.file.commit();
        this.headerBuf = null;
        this.header = null;
        this.file = null;
    }

    FileHeader getFileHeader() {
        return this.header;
    }
}

