/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import jdbm.recman.BlockIo;
import jdbm.recman.FreePhysicalRowId;
import jdbm.recman.FreePhysicalRowIdPage;
import jdbm.recman.Location;
import jdbm.recman.PageCursor;
import jdbm.recman.PageManager;
import jdbm.recman.PhysicalRowId;
import jdbm.recman.RecordFile;

final class FreePhysicalRowIdPageManager {
    protected RecordFile _file;
    protected PageManager _pageman;

    FreePhysicalRowIdPageManager(RecordFile recordFile, PageManager pageManager) throws IOException {
        this._file = recordFile;
        this._pageman = pageManager;
    }

    Location get(int n) throws IOException {
        Location location = null;
        PageCursor pageCursor = new PageCursor(this._pageman, 4);
        while (pageCursor.next() != 0L) {
            FreePhysicalRowIdPage freePhysicalRowIdPage = FreePhysicalRowIdPage.getFreePhysicalRowIdPageView(this._file.get(pageCursor.getCurrent()));
            int n2 = freePhysicalRowIdPage.getFirstLargerThan(n);
            if (n2 != -1) {
                location = new Location(freePhysicalRowIdPage.get(n2));
                int n3 = freePhysicalRowIdPage.get(n2).getSize();
                freePhysicalRowIdPage.free(n2);
                if (freePhysicalRowIdPage.getCount() == 0) {
                    this._file.release(pageCursor.getCurrent(), false);
                    this._pageman.free((short)4, pageCursor.getCurrent());
                } else {
                    this._file.release(pageCursor.getCurrent(), true);
                }
                return location;
            }
            this._file.release(pageCursor.getCurrent(), false);
        }
        return null;
    }

    void put(Location location, int n) throws IOException {
        FreePhysicalRowIdPage freePhysicalRowIdPage;
        BlockIo blockIo;
        PhysicalRowId physicalRowId = null;
        PageCursor pageCursor = new PageCursor(this._pageman, 4);
        long l = 0L;
        while (pageCursor.next() != 0L) {
            l = pageCursor.getCurrent();
            blockIo = this._file.get(l);
            freePhysicalRowIdPage = FreePhysicalRowIdPage.getFreePhysicalRowIdPageView(blockIo);
            int n2 = freePhysicalRowIdPage.getFirstFree();
            if (n2 != -1) {
                physicalRowId = freePhysicalRowIdPage.alloc(n2);
                break;
            }
            this._file.release(blockIo);
        }
        if (physicalRowId == null) {
            l = this._pageman.allocate((short)4);
            blockIo = this._file.get(l);
            freePhysicalRowIdPage = FreePhysicalRowIdPage.getFreePhysicalRowIdPageView(blockIo);
            physicalRowId = freePhysicalRowIdPage.alloc(0);
        }
        physicalRowId.setBlock(location.getBlock());
        physicalRowId.setOffset(location.getOffset());
        ((FreePhysicalRowId)physicalRowId).setSize(n);
        this._file.release(l, true);
    }
}

