/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import jdbm.recman.BlockIo;
import jdbm.recman.BlockView;

class FileHeader
implements BlockView {
    private static final short O_MAGIC = 0;
    private static final short O_LISTS = 2;
    private static final int O_ROOTS = 82;
    private BlockIo block;
    static final int NROOTS = 1013;

    FileHeader(BlockIo blockIo, boolean bl) {
        this.block = blockIo;
        if (bl) {
            blockIo.writeShort(0, (short)4944);
        } else if (!this.magicOk()) {
            throw new Error("CRITICAL: file header magic not OK " + blockIo.readShort(0));
        }
    }

    private boolean magicOk() {
        return this.block.readShort(0) == 4944;
    }

    private short offsetOfFirst(int n) {
        return (short)(2 + 16 * n);
    }

    private short offsetOfLast(int n) {
        return (short)(this.offsetOfFirst(n) + 8);
    }

    private short offsetOfRoot(int n) {
        return (short)(82 + n * 8);
    }

    long getFirstOf(int n) {
        return this.block.readLong(this.offsetOfFirst(n));
    }

    void setFirstOf(int n, long l) {
        this.block.writeLong(this.offsetOfFirst(n), l);
    }

    long getLastOf(int n) {
        return this.block.readLong(this.offsetOfLast(n));
    }

    void setLastOf(int n, long l) {
        this.block.writeLong(this.offsetOfLast(n), l);
    }

    long getRoot(int n) {
        return this.block.readLong(this.offsetOfRoot(n));
    }

    void setRoot(int n, long l) {
        this.block.writeLong(this.offsetOfRoot(n), l);
    }
}

