
if [ $# -gt 1 ] || [ "x$1" == "x-help" ] || [ "x$1" == "x--help" ] ; then
    echo "" >&2
    echo "Usage: $0 localhost-username" >&2
    echo "" >&2
    echo "For example:" >&2
    echo "    $0 greenstone" >&2
    echo "" >&2
    exit 1
fi

localhost_username=${1:-greenstone}
shift

ap_extra_args=""
echo ""
echo "####"
echo "# Checking to see if user can 'sudo' without password"

if sudo -n true 2>/dev/null; then 
    echo "#  => yes"
else
    echo "#  => no"
    ap_extra_args="$ap_extra_args    --ask-become-pass"
fi

echo "####"
echo ""


echo ""
echo "####"
echo "# Away to run the playbook with {{ gsdl3_user }}:"
echo "#    $localhost_username"
##echo "# Setting the username to install Greenstone3 as to:"
##echo "#    $localhost_username"
echo "#    $(egrep '^gsdl3srchome' vars/default-core.yml)"
echo "####"
echo ""

if [ ! -d "/home/$localhost_username" ] ; then
    
    echo "! Warning: Failed to detect /home/$localhost_username as a home directory" >&2
    echo "! " >&2
    echo "! Note: You can control the username used by providing it as a command-line argument" >&2
    echo "!   when the ansible playbook is run." >&2
    echo "! " >&2
    echo "! Or alternatively: consider using 'sudo adduser' (or similar) to create an account" >&2
    echo "!   for the missing user" >&2
    echo "" >&2
fi

echo ""
echo "Continuing in 5 seconds ..."
echo "[press <enter> to proceed immediately, or 'q' or ^C to quit]"
read -t 5  continue_answer

if [ $? == 0 ] ; then
    # keyboard input given
    
    if [ "x$continue_answer" == "xq" ] ; then
	exit 1
    fi
fi




