/*
 *    MGPassesWrapperImpl.c
 *    Copyright (C) 2002 New Zealand Digital Library, http://www.nzdl.org
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <jni.h>

#ifdef __MINGW32__

/* Cross compiling for Windows
   Want the type definitions in *win32* version of jni_md.h but
   this then leads to C-mangled style functions which we *don't*
   want.  The following achieves this */

#undef JNIEXPORT
#undef JNIIMPORT
#undef JNICALL

#define JNIEXPORT
#define JNIIMPORT
#define JNICALL
#endif

#include <assert.h>
#include "sysfuncs.h"
#include "org_greenstone_mgpp_MGPPPassesWrapper.h"

#include "mgpp_passes_4jni.h"
#include "mg_files.h"

/* if we need to use java objects, we should initialise their field ids here*/
JNIEXPORT void JNICALL
Java_org_greenstone_mgpp_MGPPPassesWrapper_initIDs(JNIEnv *j_env, jclass j_cls)
{
  return;
}

JNIEXPORT jboolean JNICALL
Java_org_greenstone_mgpp_MGPPPassesWrapper_initCSide(JNIEnv *j_env, jobject j_obj)
{
  clear_variables();
  return true;  
}  

/* add a pass type T1, T2, I1, I2, S */
JNIEXPORT void JNICALL
Java_org_greenstone_mgpp_MGPPPassesWrapper_addPass(JNIEnv *j_env, 
					       jobject j_obj, 
					       jchar j_pass_type,
					       jchar j_pass_num)
{
  /* get the level as a c char */
  const char pass_type = j_pass_type;
  const char pass_num = j_pass_num;
  add_pass(pass_type, pass_num);
  
}

/* Set the filename */
JNIEXPORT void JNICALL
Java_org_greenstone_mgpp_MGPPPassesWrapper_setFileName(JNIEnv *j_env, 
						   jobject j_obj,
						   jstring j_filename)
{
  /* Get the filename as a C string */
  const char* filename = j_env->GetStringUTFChars(j_filename, NULL);
 
  assert(filename != NULL);
  set_filename(filename);
  
  /* Release the string */
 j_env->ReleaseStringUTFChars(j_filename, filename);

}

/* Set the base path */
JNIEXPORT void JNICALL
Java_org_greenstone_mgpp_MGPPPassesWrapper_setBasePath(JNIEnv *j_env, 
						   jobject j_obj,
						   jstring j_basepath)
{
  /* Get the base_path as a C string */
  const char* basepath = j_env->GetStringUTFChars(j_basepath, NULL);
  assert(basepath != NULL);
 
  set_basepath(basepath);
  
  /* Release the string */
  j_env->ReleaseStringUTFChars(j_basepath, basepath);

}

/* set the Document tag */
JNIEXPORT void JNICALL
Java_org_greenstone_mgpp_MGPPPassesWrapper_setDocumentTag(JNIEnv *j_env, 
						      jobject j_obj,
						      jstring j_tag)
{
  const char* tag = j_env->GetStringUTFChars(j_tag, NULL);

  set_document_tag(tag);
  /* Release the string */
  j_env->ReleaseStringUTFChars(j_tag, tag);


}

/* add a level tag */
JNIEXPORT void JNICALL
Java_org_greenstone_mgpp_MGPPPassesWrapper_addLevelTag(JNIEnv *j_env, 
						   jobject j_obj,
						   jstring j_tag)
{
  const char* tag = j_env->GetStringUTFChars(j_tag, NULL);
  add_level_tag(tag);

  /* Release the string */
  j_env->ReleaseStringUTFChars(j_tag, tag);

}

/* set the index level (default word level) */
JNIEXPORT void JNICALL
Java_org_greenstone_mgpp_MGPPPassesWrapper_setIndexLevel(JNIEnv *j_env, 
						     jobject j_obj,
						     jstring j_tag)
{
  const char* tag = j_env->GetStringUTFChars(j_tag, NULL);
  set_index_level(tag);

  /* Release the string */
  j_env->ReleaseStringUTFChars(j_tag, tag);

  
}


/** Maximum amount of memory to use for  the index  pass-2  file
    inversion  in  megabytes.
*/
JNIEXPORT void JNICALL
Java_org_greenstone_mgpp_MGPPPassesWrapper_setInversionMemLimit(JNIEnv *j_env, 
							    jobject j_obj, 
							    jint j_limit) {
  int limit = j_limit;
  set_inversion_limit(limit);
}


/* initialise the pass through the documents. must be called after all
   the set methods 
*/
JNIEXPORT jboolean JNICALL 
Java_org_greenstone_mgpp_MGPPPassesWrapper_init(JNIEnv *j_env, 
					    jobject j_obj) {

  init_driver();
  return true;
}


/* process one or more documents */
JNIEXPORT jboolean JNICALL 
Java_org_greenstone_mgpp_MGPPPassesWrapper_processMGPPDocument(JNIEnv *j_env, 
						       jobject j_obj,
						       jbyteArray j_doc_text) {
  /* Get the text as a C string */
  int length = j_env->GetArrayLength(j_doc_text);
  u_char * text_buffer = (u_char *)j_env->GetByteArrayElements(j_doc_text, NULL);
  process_document(text_buffer, length);
  /* Release the string */
  // why doesn't this work in c++ when it works in C?????
  //j_env->ReleaseByteArrayElements(j_doc_text, text_buffer, 0);
  return true;
}

/* finalise the pass through the documents */
JNIEXPORT jboolean JNICALL 
Java_org_greenstone_mgpp_MGPPPassesWrapper_finish(JNIEnv *j_env, 
					    jobject j_obj) {
  
  finalise_driver();
  return true;
}

/** get the exit value once finished */
JNIEXPORT jint JNICALL 
Java_org_greenstone_mgpp_MGPPPassesWrapper_exitValue(JNIEnv *j_env, 
					    jobject j_obj) {

  return get_exit_value();
}
