#! /usr/bin/perl -w

###########################################################################
#
# symbol-names.pl -- Diagnostic tool that substitutes symbols names for 
#                    symbol numbers in the output of the suffix program. 
#
# Copyright (C) 2000 Gordon Paynter
#
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the 
# University of Waikato, New Zealand.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

$collection = shift(@ARGV);;
die "Usage: symbol-names.pl collection [file]\n" unless ($collection);

$vocab = $ENV{'GSDLHOME'} . "/collect/$collection/index/phind1/clauses.vocab";
if (-e "$vocab") {
    print "Using vocabulary from: $vocab\n";
} else {
    $vocab = $ENV{'GSDLHOME'} . "/collect/$collection/building/phind1/clauses.vocab";
    if (-e "$vocab") {
	print "Using vocabulary from: $vocab\n";
    } else {
	die "Usage: symbol-names.pl collection [file]\n" unless (-e "$vocab");
    }
}

open(V, "<$vocab");
my $n = 1;

while(<V>) {
    chomp;
    $symbol[$n++] = $_;
}

while(<>) {
    s/s(\d+)/$symbol[$1]/g;
    print;
}

