/**********************************************************************
 *
 * JdbDel.java -- 
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the 
 * University of Waikato, New Zealand.
 *
 * Copyright (C) 2009  The New Zealand Digital Library Project
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **********************************************************************/

import java.io.BufferedInputStream;
import java.io.InputStream;

import jdbm.RecordManager;
import jdbm.RecordManagerFactory;
import jdbm.helper.FastIterator;
import jdbm.htree.HTree;

import java.io.IOException;
import java.util.Properties;


public class JdbDel
{
    public static void print_usage()
    {
	System.err.println("Usage: java JdbDel database-name key");
	System.exit(-1);
    }

    
    public static void main(String[] args)
    {
	int argc = args.length;

	// sanity check
	if (argc!=2) {
	    print_usage();
	}

	try {
	    String dbname = args[0];
	    JdbmAPI jdbm_api = new JdbmAPI(dbname,true);
	    
	    String key = args[1];

	    jdbm_api.delete(key);
	    jdbm_api.close();
	}

	catch (IOException e) {
	    e.printStackTrace();
	}
		
    }

}


