/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * <BR><BR>
 *
 * Author: John Thompson, Greenstone Digital Library, University of Waikato
 *
 * <BR><BR>
 *
 * Copyright (C) 1999 New Zealand Digital Library Project
 *
 * <BR><BR>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * <BR><BR>
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * <BR><BR>
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.gui;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.gui.TestingPreparation;
import org.greenstone.gatherer.util.JarTools;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.*;

/** A lock file dialog is shown whenever GLI detects an existing lock on a collection it is trying to open. The user can look at the details provided with the dialog, and decide whether to 'steal' the lock or to cancel the loading. */
public class LockFileDialog
    extends ModalDialog {

    private int choice;
    private Document document;
    private JButton cancel_button;
    private JButton ok_button;
    private LockFileDialog self;

    static final public int NO_OPTION  = 0;
    static final public int YES_OPTION = 1;

    static final private Dimension LABEL_SIZE = new Dimension(100, 25);
    static final private Dimension SIZE = new Dimension(500, 250);
    static final private int ICON_SIZE = 30;

    public LockFileDialog(JFrame parent, String name, File lock_file) {
	super(parent, Dictionary.get("LockFileDialog.Title"), true);
        this.setComponentOrientation(Dictionary.getOrientation());
	setSize(SIZE);
	setJMenuBar(new SimpleMenuBar("openingacollection"));
	this.self = this;

	// Parse the lock file
	document = XMLTools.parseXMLFile(lock_file);

	// Creation
	JPanel content_pane = (JPanel) getContentPane();
        content_pane.setComponentOrientation(Dictionary.getOrientation());
	JPanel upper_pane = new JPanel();
        upper_pane.setComponentOrientation(Dictionary.getOrientation());
	ImageIcon icon = JarTools.getImage("lcolicn.gif");
	ImageIcon scaled_icon = new ImageIcon(icon.getImage().getScaledInstance(ICON_SIZE, ICON_SIZE, Image.SCALE_DEFAULT));
	JLabel icon_label = new JLabel(scaled_icon);
        icon_label.setComponentOrientation(Dictionary.getOrientation());
	JPanel title_pane = new JPanel();
        title_pane.setComponentOrientation(Dictionary.getOrientation());
	JLabel title_one_label = new JLabel(Dictionary.get("General.Warning"));
	title_one_label.setComponentOrientation(Dictionary.getOrientation());
	JTextArea title_two_textarea = new JTextArea(Dictionary.get("LockFileDialog.Lockfile_Message_One"));
        title_two_textarea.setComponentOrientation(Dictionary.getOrientation());
	title_two_textarea.setEditable(false);
	title_two_textarea.setLineWrap(true);
	title_two_textarea.setOpaque(false);
	title_two_textarea.setRows(3);
	title_two_textarea.setWrapStyleWord(true);
	
    	JPanel central_pane = new JPanel();
        central_pane.setComponentOrientation(Dictionary.getOrientation());
        
	JPanel name_pane = new JPanel();
        name_pane.setComponentOrientation(Dictionary.getOrientation());
	JLabel name_label = new JLabel(Dictionary.get("LockFileDialog.Name"));
        name_label.setComponentOrientation(Dictionary.getOrientation());
	name_label.setPreferredSize(LABEL_SIZE);
	
	JTextField name_field = new JTextField(name);
        name_field.setComponentOrientation(Dictionary.getOrientation());
	name_field.setEditable(false);
	name_field.setBackground(Configuration.getColor("coloring.collection_tree_background", false));


        JPanel person_pane = new JPanel();
	person_pane.setComponentOrientation(Dictionary.getOrientation());
        JLabel person_label = new JLabel(Dictionary.get("LockFileDialog.User"));
        person_label.setComponentOrientation(Dictionary.getOrientation());
	person_label.setPreferredSize(LABEL_SIZE);
	
	JTextField person_field = new JTextField(getValue("User"));
        person_field.setComponentOrientation(Dictionary.getOrientation());
	person_field.setEditable(false);
	person_field.setBackground(Configuration.getColor("coloring.collection_tree_background", false));

	JPanel machine_pane = new JPanel();
        machine_pane.setComponentOrientation(Dictionary.getOrientation());
	JLabel machine_label = new JLabel(Dictionary.get("LockFileDialog.Machine"));
        machine_label.setComponentOrientation(Dictionary.getOrientation());
	machine_label.setPreferredSize(LABEL_SIZE);
	
	JTextField machine_field = new JTextField(getValue("Machine"));
        machine_field.setComponentOrientation(Dictionary.getOrientation());
	machine_field.setEditable(false);
	machine_field.setBackground(Configuration.getColor("coloring.collection_tree_background", false));

	JPanel created_pane = new JPanel();
        created_pane.setComponentOrientation(Dictionary.getOrientation());
	JLabel created_label = new JLabel(Dictionary.get("LockFileDialog.Date"));
	created_label.setPreferredSize(LABEL_SIZE);
        created_label.setComponentOrientation(Dictionary.getOrientation());
	
	JTextField created_field = new JTextField(getValue("Date"));
        created_field.setComponentOrientation(Dictionary.getOrientation());
	created_field.setEditable(false);
	created_field.setBackground(Configuration.getColor("coloring.collection_tree_background", false));

	JLabel central_label = new JLabel(Dictionary.get("LockFileDialog.Lockfile_Message_Two"));
	central_label.setComponentOrientation(Dictionary.getOrientation());
        
	JPanel button_pane = new JPanel();
        button_pane.setComponentOrientation(Dictionary.getOrientation());
	ok_button = new GLIButton(Dictionary.get("General.OK"), Dictionary.get("LockFileDialog.OK_Tooltip"));
	
	cancel_button = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("LockFileDialog.Cancel_Tooltip"));
	
	// Connection
	ok_button.addActionListener(new MyActionListener());
	cancel_button.addActionListener(new MyActionListener());

	// Layout
	icon_label.setBorder(BorderFactory.createEmptyBorder(0,0,0,10));

	title_pane.setLayout(new BorderLayout());
	title_pane.add(title_one_label, BorderLayout.NORTH);
	title_pane.add(title_two_textarea, BorderLayout.CENTER);

	upper_pane.setLayout(new BorderLayout());
	upper_pane.add(icon_label, BorderLayout.LINE_START);
	upper_pane.add(title_pane, BorderLayout.CENTER);

	name_pane.setLayout(new BorderLayout());
	name_pane.add(name_label, BorderLayout.LINE_START);
	name_pane.add(name_field, BorderLayout.CENTER);

	person_pane.setLayout(new BorderLayout());
	person_pane.add(person_label, BorderLayout.LINE_START);
	person_pane.add(person_field, BorderLayout.CENTER);

	machine_pane.setLayout(new BorderLayout());
	machine_pane.add(machine_label, BorderLayout.LINE_START);
	machine_pane.add(machine_field, BorderLayout.CENTER);

	created_pane.setLayout(new BorderLayout());
	created_pane.add(created_label, BorderLayout.LINE_START);
	created_pane.add(created_field, BorderLayout.CENTER);

	central_pane.setLayout(new GridLayout(5,1,0,5));
	central_pane.add(name_pane);
	central_pane.add(person_pane);
	central_pane.add(machine_pane);
	central_pane.add(created_pane);
	central_pane.add(central_label);

	button_pane.setLayout(new GridLayout(1,2,5,0));
	button_pane.add(ok_button);
	button_pane.add(cancel_button);

	content_pane.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
	content_pane.setLayout(new BorderLayout());
	content_pane.add(upper_pane, BorderLayout.NORTH);
	content_pane.add(central_pane, BorderLayout.CENTER);
	content_pane.add(button_pane, BorderLayout.SOUTH);

	// Display
	if (parent != null) {
	    Rectangle frame_bounds = parent.getBounds();
	    setLocation(frame_bounds.x + (frame_bounds.width - SIZE.width) / 2, frame_bounds.y + (frame_bounds.height - SIZE.height) / 2);
	}
	else {
	    Dimension screen_size = Toolkit.getDefaultToolkit().getScreenSize();
	    setLocation((screen_size.width - SIZE.width) / 2, (screen_size.height - SIZE.height) / 2);
	}

	TestingPreparation.setNamesRecursively(this);
    }

    public int getChoice() {
	setVisible(true);
	return choice;
    }

    private String getValue(String name) {
	String value = "";
	if(document != null) {
	    try {
		Element value_element = (Element) XMLTools.getNodeFromNamed(document.getDocumentElement(), name);
		value = XMLTools.getValue(value_element);
	    }
	    catch (Exception error) {
	    }
	}
	else {
	    value = Dictionary.get("LockFileDialog.Error");
	}
	return value;
    }

    private class MyActionListener
	implements ActionListener {
	public void actionPerformed(ActionEvent event) {
	    if(event.getSource() == ok_button) {
		choice = YES_OPTION;
	    }
	    else {
		choice = NO_OPTION;
	    }
	    self.dispose();
	}
    }
}
