<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:java="http://xml.apache.org/xslt/java"
                xmlns:util="xalan://org.greenstone.gsdl3.util.XSLTUtil"
                xmlns:gslib="http://www.greenstone.org/skinning"
                xmlns:gsf="http://www.greenstone.org/greenstone3/schema/ConfigFormat"
                extension-element-prefixes="java util"
                exclude-result-prefixes="java util gsf">

  <xsl:template name="additionalHeaderContent-collection">
    <xsl:variable name="httpCollection">
      <xsl:value-of select="/page/pageResponse/collection/metadataList/metadata[@name='httpPath']"/>
    </xsl:variable>
    <link rel="stylesheet" href="{$httpCollection}/style/gs3-style-default-extra.css" type="text/css" 
	  title="GS3 Style" id="custom-style" charset="UTF-8"/>				
    <script src="{$httpCollection}/script/custom-script.js" type="text/javascript"><xsl:text> </xsl:text></script>
  </xsl:template>

  <xsl:template name="create-banner">  
    <div class="choose_style">
      <gsf:collectionText name="choose-style" propertyFile="collectionConfig"/>
      <a href="#" onclick="replaceStyle('gs3-style-default-extra');return false;"><gsf:collectionText name="style.default" propertyFile="collectionConfig"/></a>,
      <a href="#" onclick="replaceStyle('gs3-style-blue');return false;"><gsf:collectionText name="style.blue" propertyFile="collectionConfig"/></a>,
      <a href="#" onclick="replaceStyle('gs3-style-olive-purple');return false;"><gsf:collectionText name="style.olive" propertyFile="collectionConfig"/></a>,
      <a href="#" onclick="replaceStyle('');return false;"><gsf:collectionText name="style.none" propertyFile="collectionConfig"/></a>
    </div>
			
    <div id="gs_banner" class="ui-widget-header ui-corner-bottom">	    
      <div id="titlesearchcontainer">
	<xsl:call-template name="page-title-area"/>	
	<xsl:call-template name="quick-search-area"/>
	<div style="clear:both;"><xsl:text> </xsl:text></div>	
      </div>
      <xsl:call-template name="browsing-tabs"/>
    </div>
  </xsl:template>
  
</xsl:stylesheet>
