<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="/Go">
	<HTML>
	<HEADER>
		<TITLE><xsl:value-of select="Go/GoGame/@name"/></TITLE>
	</HEADER>
	<BODY>
		<xsl:apply-templates select="GoGame"/>
	</BODY>
	</HTML>
</xsl:template>

<xsl:template match="GoGame">
	<H1 align="right"><xsl:value-of select="@name"/></H1>
	<xsl:apply-templates select="Information"/>
	<H2>Moves</H2>
	<xsl:apply-templates select="Nodes"/>
</xsl:template>

<xsl:template match="Nodes">
	<xsl:apply-templates select="Node|Variation|Black|White|Comment"/>
</xsl:template>

<xsl:template match="Information">
	<H2>Game Information</H2>
	<P>
	<xsl:apply-templates select="BlackPlayer"/>
	<xsl:apply-templates select="WhitePlayer"/>
	<xsl:apply-templates select="Date"/>
	<xsl:apply-templates select="Time"/>
	<xsl:apply-templates select="Komi"/>
	<xsl:apply-templates select="Result"/>
	<xsl:apply-templates select="BoardSize"/>
	</P>
	<P>
	<xsl:apply-templates select="Application"/>
	<xsl:apply-templates select="User"/>
	</P>
	<xsl:apply-templates select="Copyright"/>
</xsl:template>

<xsl:template match="WhitePlayer">
	<B>White: </B><xsl:value-of select="."/>
	<xsl:apply-templates select="../WhiteRank"/>
	<BR></BR>
</xsl:template>

<xsl:template match="BlackPlayer">
	<B>White: </B><xsl:value-of select="."/>
	<xsl:apply-templates select="../BlackRank"/>
	<BR></BR>
</xsl:template>

<xsl:template match="WhiteRank|BlackRank">
	(<xsl:value-of select="."/>)
</xsl:template>

<xsl:template match="Date">
	<B>Date: </B><xsl:value-of select="."/><BR></BR>
</xsl:template>

<xsl:template match="Time">
	<B>Time: </B><xsl:value-of select="."/><BR></BR>
</xsl:template>

<xsl:template match="Komi">
	<B>Komi: </B><xsl:value-of select="."/><BR></BR>
</xsl:template>

<xsl:template match="Result">
	<B>Result: </B><xsl:value-of select="."/><BR></BR>
</xsl:template>

<xsl:template match="BoardSize[.='19']">
</xsl:template>

<xsl:template match="BoardSize">
	<B>Boardsize: </B><xsl:value-of select="."/><BR></BR>
</xsl:template>

<xsl:template match="Application">
	<B>Application: </B><xsl:value-of select="."/><BR></BR>
</xsl:template>

<xsl:template match="User">
	<B>User: </B><xsl:value-of select="."/><BR></BR>
</xsl:template>

<xsl:template match="Copyright">
	<H2>Copyright</H2>
	<xsl:apply-templates select="P"/>
</xsl:template>

<xsl:template match="P">
	<P><xsl:value-of select="."/></P>
</xsl:template>

<xsl:template match="Node">
	<DIV>
	<xsl:apply-templates select="Black"/>
	<xsl:apply-templates select="White"/>
	<xsl:apply-templates select="AddBlack[position()=1]"/>
	<xsl:apply-templates select="AddWhite[position()=1]"/>
	<xsl:apply-templates select="Delete[position()=1]"/>
	<xsl:apply-templates select="Mark[position()=1]"/>
	<xsl:apply-templates select="Comment"/>
	<P></P>
	</DIV>
</xsl:template>

<xsl:template match="Variation">
	<DIV STYLE="position:relative; left:10%">
	<H3>Variation</H3>
	<xsl:apply-templates select="Node|Variation|Black|White|Comment"/>
	</DIV>
</xsl:template>

<xsl:template match="White">
	<TABLE BORDER="1" WIDTH="40%">
		<TR>
			<TD WIDTH="50%">
			</TD>
			<TD WIDTH="50%">
			<B>
			<xsl:if test="@number"><xsl:value-of select="@number"/>.</xsl:if>
			White <xsl:value-of select="@at"/></B>
			</TD>
		</TR>
	</TABLE>
</xsl:template>

<xsl:template match="Black">
	<TABLE BORDER="1" WIDTH="40%">
		<TR>
			<TD WIDTH="50%">
			<B>
			<xsl:if test="@number"><xsl:value-of select="@number"/>.</xsl:if>
			Black <xsl:value-of select="@at"/></B>
			</TD>
			<TD WIDTH="50%">
			</TD>
		</TR>
	</TABLE>
</xsl:template>

<xsl:template match="Comment">
	<xsl:apply-templates select="P"/>
</xsl:template>

<xsl:template match="AddBlack">
	<P>
	<B>Set Black: </B>
	<xsl:for-each select="../AddBlack">
		<xsl:sort select="@at"/>
		<xsl:value-of select="@at"/>
		<xsl:if test="not(position()=last())">, </xsl:if>
	</xsl:for-each>
	</P>
</xsl:template>

<xsl:template match="AddWhite">
	<P>
	<B>Set White: </B>
	<xsl:for-each select="../AddWhite">
		<xsl:sort select="@at"/>
		<xsl:value-of select="@at"/>
		<xsl:if test="not(position()=last())">, </xsl:if>
	</xsl:for-each>
	</P>
</xsl:template>

<xsl:template match="Delete">
	<P>
	<B>Remove: </B>
	<xsl:for-each select="../Delete">
		<xsl:sort select="@at"/>
		<xsl:value-of select="@at"/>
		<xsl:if test="not(position()=last())">, </xsl:if>
	</xsl:for-each>
	</P>
</xsl:template>

<xsl:template match="Mark">
	<P>
	<B>Mark: </B>
	<xsl:for-each select="../Mark">
		<xsl:sort select="@at"/>
		<xsl:value-of select="@at"/>
		<xsl:if test="@type='triangle'"> with triangle</xsl:if>
		<xsl:if test="@type='square'"> with square</xsl:if>
		<xsl:if test="@type='circle'"> with circle</xsl:if>
		<xsl:if test="@label"> with <xsl:value-of select="@label"/></xsl:if>
		<xsl:if test="@territory"> as <xsl:value-of select="@territory"/> territory</xsl:if>
		<xsl:if test="not(position()=last())">, </xsl:if>
	</xsl:for-each>
	</P>
</xsl:template>

</xsl:stylesheet>
