<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:java="http://xml.apache.org/xslt/java" xmlns:util="xalan://org.greenstone.gsdl3.util.XSLTUtil" xmlns:gslib="http://www.greenstone.org/skinning" xmlns:gsf="http://www.greenstone.org/greenstone3/schema/ConfigFormat" extension-element-prefixes="java util" exclude-result-prefixes="java util gsf">

  <!-- use the 'main' layout -->
  <xsl:import href="layouts/main.xsl" />
  <xsl:import href="layouts/webswing-collage.xsl" />
  <xsl:import href="map-tools.xsl" />
  <xsl:import href="panorama-viewer-tools.xsl" />

  <!-- set page title -->
  <xsl:template name="pageTitle">
    <gslib:serviceName />
  </xsl:template>

  <!-- set page breadcrumbs -->
  <xsl:template name="breadcrumbs">
    <gslib:siteLink />
    <gslib:rightArrow />
    <gslib:groupLinks/>
    <gslib:collectionNameLinked />
    <gslib:rightArrow />
  </xsl:template>

  <!-- the page content -->
  <xsl:template match="/page/pageResponse">
    <xsl:call-template name="floatRightSidebar" />
    <xsl:call-template name="classifierPre" />

    <script type="text/javascript" src="interfaces/{$interface_name}/js/classifier_scripts.js">
      <xsl:text> </xsl:text>
    </script>
    <gsf:script type="text/javascript">$(window).on("load", openStoredClassifiers);</gsf:script>

    <!-- 
      Show the clasifier results - you can change the appearance of the results
      by editing the two templates at the bottom of this file
    -->
    <div id="results">
      <xsl:variable name="collName">
        <xsl:value-of select="/page/pageRequest/paramList/param[@name='c']/@value" />
      </xsl:variable>
      <xsl:variable name="serviceName">
        <xsl:value-of select="service/@name" />
      </xsl:variable>
      
      <xsl:call-template name="classifierResultsPre" />
      
      <xsl:apply-templates select="classifier">
        <xsl:with-param name="collName" select="$collName" />
        <xsl:with-param name="serviceName" select="$serviceName" />
      </xsl:apply-templates>
      
      <xsl:call-template name="classifierResultsPost" />
      
      <xsl:call-template name="classifierPost" />      
      
    </div>

    <div class="clear">
      <xsl:text> </xsl:text>
    </div>
  </xsl:template>

  <xsl:template name="rightSidebar">
	<!-- https://stackoverflow.com/questions/1299808/in-xslt-how-do-you-test-to-see-if-a-variable-exists -->
    <!--<xsl:if test="string-length($haveBasketsToDisplay)">-->
    <div id="rightSidebar"><xsl:text> </xsl:text>
      <gslib:displayBaskets />
    </div>
    <!--</xsl:if>-->
  </xsl:template>

  <xsl:template match="classifier">
    <xsl:param name="collName" />
    <xsl:param name="serviceName" />
    <div id="classifiers">
      <xsl:variable name="cl_name">
        <xsl:value-of select="@name" />
      </xsl:variable>
      <xsl:choose>
        <xsl:when test="@childType = 'HList'">
          <xsl:call-template name="HList">
            <xsl:with-param name='collName' select='$collName' />
            <xsl:with-param name='serviceName' select='$serviceName' />
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
	  <table class="childrenlist" id="div{@nodeID}">
	    
          <!--<table id="classifiernodelist">-->
            <xsl:text> </xsl:text>
            <xsl:call-template name="processNodeChildren">
              <xsl:with-param name='collName' select='$collName' />
              <xsl:with-param name='serviceName' select='$serviceName' />
            </xsl:call-template>
          </table>
        </xsl:otherwise>
      </xsl:choose>
    </div>
  </xsl:template>

  <xsl:template name="HList">
    <xsl:param name="collName" />
    <xsl:param name="serviceName" />
    <xsl:variable name="selectedNode">
      <xsl:value-of select="/page/pageRequest/paramList/param[@name = 'cl']/@value" />
    </xsl:variable>

    <ul class="horizontalContainer">
      <xsl:for-each select='classifierNode'>
        <li id="title{@nodeID}">
          <xsl:attribute name="class">
<!--            <xsl:if test="$selectedNode = @nodeID or starts-with($selectedNode, concat(@nodeID, '.')) or (not(contains($selectedNode, '.')) and @nodeID = concat($selectedNode, '.1'))">selectedHorizontalClassifierNode </xsl:if>-->
             <xsl:if test="$selectedNode = @nodeID or starts-with($selectedNode, concat(@nodeID, '.')) or (@nodeID = concat($selectedNode, '.1'))">selectedHorizontalClassifierNode </xsl:if>
            <xsl:text>horizontalClassifierNode</xsl:text>
          </xsl:attribute>
          <xsl:apply-templates select='.'>
            <xsl:with-param name='collName' select='$collName' />
            <xsl:with-param name='serviceName' select='$serviceName' />
          </xsl:apply-templates>
        </li>
      </xsl:for-each>
    </ul>
    <xsl:choose>
      <!-- if there is a child that is an HList, and it has a classifierNode child (ie its been selected in the classifier-->
      <xsl:when test="classifierNode[@childType = 'HList']/classifierNode">
        <xsl:for-each select="classifierNode[@childType = 'HList']">
	  <!-- only process this node if it has a classifier child (ie its the selected HList) - all the top level nodes are present in the classifier XML -->
	  <xsl:if test="classifierNode">
            <!-- there should be only one-->
            <xsl:call-template name="HList">
              <xsl:with-param name='collName' select='$collName' />
              <xsl:with-param name='serviceName' select='$serviceName' />
            </xsl:call-template>
	  </xsl:if>
        </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>

        <div id="classifiernodelist{@nodeID}">
        <xsl:for-each select='classifierNode'>
	  <xsl:if test="classifierNode|documentNode">
	  	<table class="childrenlist" id="div{@nodeID}">
            <xsl:call-template name="processNodeChildren">
              <xsl:with-param name='collName' select='$collName' />
              <xsl:with-param name='serviceName' select='$serviceName' />
            </xsl:call-template>
		</table>
	  </xsl:if>
          </xsl:for-each>
        </div>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="Collage_javascript_deprecated">
    <script type="text/javascript" src="interfaces/{$interface_name}/js/collage_scripts.js"><xsl:text> </xsl:text></script>
		<div id="collagewrapper" style="width: 800px; height: 643px; position: relative; background-image:url('sites/{$site_name}/collect/twso/images/oldimagebackground1.png'); text-align: center;" alt="Click to start/stop a collage of images" title="Click to start/stop a collage of images" onmouseover="" onmouseout=""><xsl:text> </xsl:text></div>
    
  </xsl:template>

  <xsl:template name="processNodeChildren">
    <xsl:param name="collName" />
    <xsl:param name="serviceName" />

    <xsl:choose>

      <xsl:when test="@childType = 'VList' or @childType = 'DateList'">
        <!--	
	      <xsl:when test="@childType = 'VList' or @childType = 'HList' or @childType = 'DateList'"> - - **** mod ???? - -
	      -->

        <xsl:value-of select="util:storeString('prevMonth', '')" />
        <xsl:for-each select='classifierNode|documentNode'>
          <tr>
            <xsl:choose>
              <xsl:when test="name()='documentNode'">
                <xsl:if test="../@childType = 'DateList'">
                  <xsl:variable name="prevMonth">
                    <xsl:value-of select="util:getString('prevMonth')" />
                  </xsl:variable>
                  <xsl:variable name="currentDate">
                    <gsf:metadata name="Date" pos="1" />
                  </xsl:variable> <!-- note pos=1 won't work if a document can be included in a datelist multiple times. currently only the first date is used...-->
                  <xsl:variable name="currentMonth">
                    <xsl:value-of select="util:getDetailFromDate($currentDate, 'month', /page/@lang)" />
                  </xsl:variable>
                  <xsl:value-of select="util:storeString('prevMonth', $currentMonth)" />
                  <td>
                    <xsl:if test="not($currentMonth = $prevMonth)">
                      <xsl:value-of select="$currentMonth" />
                    </xsl:if>
                    <xsl:text> </xsl:text>
                  </td>
                </xsl:if>
                <td>
                  <table id="div{@nodeID}">
                    <tr>
                      <xsl:call-template name="documentNodeWrapper">
                        <xsl:with-param name='collName' select='$collName' />
                        <xsl:with-param name='serviceName' select='$serviceName' />
                      </xsl:call-template>
                    </tr>
                  </table>
                </td>
              </xsl:when>
              <xsl:when test="name()='classifierNode' and (@childType = 'VList' or @childType = 'HList')">
                <!-- *** mod -->
                <td>
                  <table id="title{@nodeID}">
                    <tr>
                      <xsl:if test="not(/page/pageResponse/format[@type='browse']/gsf:option[@name='turnstyleClassifiers']) or /page/pageResponse/format[@type='browse']/gsf:option[@name='turnstyleClassifiers']/@value='true'">
                        <td class="headerTD">
                          <img id="toggle{@nodeID}" onclick="toggleSection('{@nodeID}');" class="icon turnstyleicon">
                            <xsl:attribute name="src">
                              <xsl:choose>
                                <xsl:when test="classifierNode or documentNode">
                                  <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'collapse_image')" />
                                </xsl:when>
                                <xsl:otherwise>
                                  <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'expand_image')" />
                                </xsl:otherwise>
                              </xsl:choose>
                            </xsl:attribute>
                          </img>
                        </td>
                      </xsl:if>
                      <xsl:apply-templates select='.'>
                        <xsl:with-param name='collName' select='$collName' />
                        <xsl:with-param name='serviceName' select='$serviceName' />
                      </xsl:apply-templates>
                    </tr>
                  </table>
                </td>
                <xsl:if test="child::classifierNode or child::documentNode">
                  <!--recurse into the children-->
                  <tr>
                    <td>
                      <table class="childrenlist" id="div{@nodeID}">
			
			<xsl:apply-templates select='.' mode='process-all-children'>
                          <xsl:with-param name='collName' select='$collName' />
                          <xsl:with-param name='serviceName' select='$serviceName' />
                        </xsl:apply-templates>
                      </table>
                    </td>
                  </tr>
                </xsl:if>
              </xsl:when>
              <xsl:otherwise>
                <td>
                  Unknown classifier style specified:
                  <xsl:value-of select="name()" />
                </td>
              </xsl:otherwise>
            </xsl:choose>
          </tr>
        </xsl:for-each>
      </xsl:when>
      <xsl:when test="@childType = 'HTML'">
        <xsl:variable name="URL">
          <xsl:value-of select="documentNode/@nodeID" />
        </xsl:variable>
        <iframe width="100%" height="600" frameborder="0">
          <xsl:attribute name="src">
            <xsl:value-of select="$URL" />
          </xsl:attribute>
          Frame for
          <xsl:value-of select="$URL" />
        </iframe>
      </xsl:when>
      <xsl:when test="@childType = 'Collage'">
	<xsl:choose>
	  <!--test of not(*) means has no children, not(classNode) has no subelements classNode-->
	  <xsl:when test="not(classifierNode)">
	    <!-- the order of calling these templates now matters since the collage applet now
		 serves as a shim in the javascript that gets loaded in the 2nd template call:
		 the javascript now reads in the applet's parameters and uses them to configure
		 the webswing application/applet. It appeared better than the entirely javascript
		 solution we already had (which set the webswing arguments from the pageRequest
		 and xslt variables), as javascript requires familiarity with programming and
		 library designers/developers/we may find it easier to configure applet params
		 than learn/remember how to set webswing params or use javascript.
	    -->
	    <xsl:call-template name="get-collage-settings" />
	    <div id="collage-displaying-info" style="display:none">The Collage Java App</div>
	    <xsl:call-template name="webswing-embed-collage"/>
	  </xsl:when>
	  <xsl:otherwise>
	    <xsl:apply-templates select='classifierNode|documentNode' mode='process-all-children'>
              <xsl:with-param name='collName' select='$collName' />
              <xsl:with-param name='serviceName' select='$serviceName' />
            </xsl:apply-templates>
	  </xsl:otherwise>
	</xsl:choose>	
      </xsl:when>
      <xsl:otherwise>
	      we are in the other wise
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- processing for the recursive bit -->
  <xsl:template match="classifierNode" mode="process-all-children">
    <xsl:param name="collName" />
    <xsl:param name="serviceName" />

    <!--
	***mod: previous, simpler version
    <xsl:call-template name="processNodeChildren">
      <xsl:with-param name='collName' select='$collName'/>
      <xsl:with-param name='serviceName' select='$serviceName'/>
    </xsl:call-template>
    -->

    <xsl:choose>
      <xsl:when test="@childType = 'HList'">
	<tr><td>
        <xsl:call-template name="HList">
          <xsl:with-param name='collName' select='$collName' />
          <xsl:with-param name='serviceName' select='$serviceName' />
        </xsl:call-template>
      </td></tr>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="processNodeChildren">
          <xsl:with-param name='collName' select='$collName' />
          <xsl:with-param name='serviceName' select='$serviceName' />
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>

  </xsl:template>

  <!-- this is a wrapper node, which the interface can use to add stuff into the classifier display that isn't part of and doesn't depend on the documentNode template which may come from the collection -->
  <xsl:template name="documentNodeWrapper">
    <xsl:param name="collName" />
    <xsl:param name="serviceName" />

    <!-- The favourite star (optional) -->
    <xsl:if test="$favouriteBasketOn">
      <td valign="top">
        <xsl:call-template name="documentFavouriteForClassifierOrSearchPage" />
      </td>
    </xsl:if>

    <xsl:apply-templates select=".">
      <xsl:with-param name="collName" select="$collName" />
      <xsl:with-param name="serviceName" select="$serviceName" />
    </xsl:apply-templates>
    
    <xsl:call-template name="documentNodePost" />
  </xsl:template>

  <!--
      TEMPLATE FOR DOCUMENTS
  -->
  <xsl:template match="documentNode">
    <td valign="top">
      <gsf:link type="document">
        <gsf:icon type="document" />
      </gsf:link>
    </td>
    <td valign="top">
      <gsf:link type="source">
        <gsf:choose-metadata>
          <gsf:metadata name="thumbicon" />
          <gsf:metadata name="srcicon" />
        </gsf:choose-metadata>
      </gsf:link>
    </td>
    <td valign="top">
      <gsf:link type="document">
        <!-- Defined in header.xsl -->
        <xsl:call-template name="choose-title" />
        <gsf:switch>
          <gsf:metadata name="Source" />
          <gsf:when test="exists">
            <br />
            <i>
              (
              <gsf:metadata name="Source" />
              )
            </i>
          </gsf:when>
        </gsf:switch>
      </gsf:link>
    </td>
  </xsl:template>

  <xsl:template name="documentNodePost">
    <xsl:if test="/page/pageResponse/format[@type='display' or @type='browse' or @type='search']/gsf:option[@name='mapEnabled']/@value = 'true'">
      <xsl:if test="metadataList/metadata[@name='Latitude' or @name='Longitude' or @name='Coordinate']">
        <xsl:call-template name="mapFeaturesIcon" />
      </xsl:if>
    </xsl:if>

    <xsl:if test="/page/pageResponse/format/gsf:option[@name='panoramaViewerEnabled']/@value = 'true'">
      <xsl:if test="metadataList/metadata[@name = 'PhotoType']='Panorama' and ( metadataList/metadata[@name = 'Coordinate'] or ( metadataList/metadata[@name = 'Latitude'] and metadataList/metadata[@name = 'Longitude']))">
        <xsl:call-template name="panoramaViewerFeaturesIcon" />
      </xsl:if>
    </xsl:if>

  </xsl:template>

  <!--
      TEMPLATE FOR GROUPS OF DOCUMENTS
  -->
  <xsl:template match="classifierNode[@classifierStyle = 'HList']">
    <gsf:link type="classifier">
      <gsf:metadata name="Title" />
    </gsf:link>
  </xsl:template>

  <xsl:template match="classifierNode">
    <td valign="top">
      <gsf:link type="classifier" style="static">
        <gsf:icon type="classifier" />
      </gsf:link>
    </td>
    <td valign="top">
      <gsf:link type="classifier">
        <gsf:metadata name="Title" />
      </gsf:link>
    </td>
  </xsl:template>

  <xsl:template name="classifierPre">
    <xsl:if test="/page/pageResponse/format[@type='display' or @type='browse' or @type='search']/gsf:option[@name='mapEnabled']/@value = 'true'">
      <xsl:call-template name="mapFeaturesJSONNodes" />
    </xsl:if>

    <xsl:if test="/page/pageResponse/format/gsf:option[@name='panoramaViewerEnabled']/@value = 'true'">
      <xsl:call-template name="panoramaViewerFeaturesJSONNodes" />
    </xsl:if>

  </xsl:template>

  <xsl:template name="classifierResultsPre">
    <xsl:if test="/page/pageResponse/format[@type='display' or @type='browse' or @type='search']/gsf:option[@name='mapEnabled']/@value = 'true'">
      <xsl:call-template name="mapFeaturesMap" />
    </xsl:if>
    <xsl:if test="/page/pageResponse/format/gsf:option[@name='panoramaViewerEnabled']/@value = 'true'">
      <xsl:call-template name="panoramaViewerFeatures" />
    </xsl:if>
  </xsl:template>

  <xsl:template name="classifierResultsPost">
  </xsl:template>

  <xsl:template name="classifierPost">
  </xsl:template>

  <xsl:template match="/page/xsltparams">
    <!-- suppress xsltparam block in page -->
  </xsl:template>

</xsl:stylesheet>
