#!/bin/bash

package=dbus
version=-1.6.8

progname=$0

source ../cascade-make/lib/cascade-lib.bash GEXTGNOME ../.. $*

prefix=$GEXTGNOME_INSTALLED

if [ "x$crossOS" = "xandroid" ] ; then
  # Based on details found at:
  #   http://axcoto.com/blog/article/836
  extra_config_args="glib_cv_stack_grows=${glib_cv_stack_grows=no} glib_cv_uscore=${glib_cv_uscore=no} ac_cv_func_posix_getpwuid_r=${ac_cv_func_posix_getpwuid_r=no} ac_cv_func_posix_getgrgid_r=${ac_cv_func_posix_getgrgid_r=no} ac_cv_func_posix_getpwnam_r=no ac_cv_func_posix_getgrnam_r=no"
else
  extra_config_args=
fi

opt_run_untar $force_untar $auto_untar $package $version
opt_run_configure $force_config $auto_config $package $version $prefix \
  --disable-tests \
  --with-glib=no \
  $extra_config_args

opt_run_make $compile $package $version
opt_run_make $install $package $version "install"
opt_run_make $clean $package $version "clean"
opt_run_make $distclean $package $version "distclean"

opt_run_tarclean $tarclean $package $version

